package com.tykj.workflowcore.model_layer.controller;


import com.tykj.workflowcore.model_layer.model.ColumnInfo;
import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.model_layer.model.TableVO;
import com.tykj.workflowcore.model_layer.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelController
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:35
 * @Version 1.0
 */
@RestController
@RequestMapping("/model")
public class ModelController {
    @Autowired
    private ModelService modelService;

    @RequestMapping("/getAllEntity")
    public List<TableInfo> getAllEntity() {

        List<TableInfo> tableInfos = null;
        try {
            tableInfos = modelService.ListAllEntities();
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return tableInfos;
    }

    @GetMapping("/getAllField")
    public List<ColumnInfo>  getFields(String tableName) {

        List<ColumnInfo> all = modelService.showModelFields(tableName);
        return all;
    }

    @PostMapping("/addModel")
    //入参使用VO直接接收即可
    //jsonStr -> TableVo
    public ResponseEntity addModel(@RequestBody TableVO tableVO) throws Exception {
        List<TableInfo> tableInfos = modelService.ListAllEntities();
        for (TableInfo tableInfo : tableInfos) {
            if (tableVO.getModelName()!=null&&tableVO.getModelName().equals(tableInfo.getName())){
                return new ResponseEntity(HttpStatus.BAD_GATEWAY);
            }
        }
        modelService.NewTable(tableVO);

        return new ResponseEntity(HttpStatus.OK);

    }
    @PostMapping("/insertValues")
    public int insertValues(@RequestBody Map<String,Object> map){
        int i = modelService.putValueByEntityName(map);
        return i;

    }
}
