package com.tykj.workflowcore.model_layer.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import com.tykj.workflowcore.model_layer.dao.ColumnInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.model.ColumnInfo;
import com.tykj.workflowcore.model_layer.model.ColumnVO;
import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.model_layer.model.TableVO;
import com.tykj.workflowcore.model_layer.service.ModelService;
import com.tykj.workflowcore.model_layer.utils.CreatTableUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;


import javax.persistence.Query;
import javax.persistence.criteria.*;
import javax.xml.crypto.Data;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @ClassName MoedelImpl
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:39
 * @Version 1.0
 */
@Transactional
@Service
public class ModelImpl implements ModelService {



    @Autowired
    private EntityManagerFactory entityManagerFactory;

    @Autowired
    private TableInfoDao tableInfoDao;

    @Autowired
    private ColumnInfoDao columnInfoDao;


    @Override
    public List<TableInfo> ListAllEntities() {
        List<TableInfo> all = tableInfoDao.findAll();
        return all;
    }


    @Override
    public List<ColumnInfo> showModelFields(String TableName) {

        Specification specification = (Specification) (root, criteriaQuery, criteriaBuilder) -> {
            Path db_name = root.get("DbName");
            Predicate equal = criteriaBuilder.equal(db_name, TableName);
            return equal;

        };
        List<ColumnInfo> all = columnInfoDao.findAll(specification);
        return all;
    }

    @Override
    public TableVO addModel(String jsonStr) {
        ObjectMapper mapper = new ObjectMapper();
        TableVO tableVO = null;
        try {
            tableVO = mapper.readValue(jsonStr, TableVO.class);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return tableVO;
    }

    @Override
    public TableVO NewTable(TableVO tableVO) {

        String XML_MAPPING = CreatTableUtil.CreatTable(tableVO);
        CreatTableUtil creatTableUtil = new  CreatTableUtil();
        Session session = creatTableUtil.getSession(entityManagerFactory,XML_MAPPING);

        List<ColumnVO> dataList = tableVO.getDataList();

        TableInfo tableInfo = new TableInfo();

        tableInfo.setName(tableVO.getModelName());
        tableInfo.setCnName(tableVO.getModelTitle());

        tableInfo.setXML(XML_MAPPING);

        tableInfoDao.save(tableInfo);

        for (ColumnVO columnVO : dataList) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setName(columnVO.getFieldName());
            columnInfo.setType(columnVO.getFiledType());
            columnInfo.setLength(columnVO.getFiledLength());
            columnInfo.setCnName(columnVO.getFiledDescription());
            columnInfo.setDbName(tableInfo.getCnName());
            columnInfo.setDbId(tableInfo.getId());
            columnInfoDao.save(columnInfo);

        }
        //关闭会话
        session.close();
        return tableVO;
    }

    @Override
    public int putValueByEntityName(Map<String, Object> map) {
        for (String tableName:
             map.keySet()) {
            //查找对应的表
            Specification spec = (Specification) (root, criteriaQuery, criteriaBuilder) -> {
                Predicate equal = null;
                Path name = root.get("Name");
                equal = criteriaBuilder.equal(name, tableName);
                return equal;
            };
            Optional one = tableInfoDao.findOne(spec);
            TableInfo tableInfo = null;
            if (one.isPresent()){
                tableInfo = (TableInfo) one.get();
            }

            Object values = map.get(tableName);
            if (values instanceof Map){
                //插入数据
                insertValue(tableInfo.getName(),tableInfo.getXML(), (Map) values);
            }else {
                //循环插入数据
                List valuesList = (List) values;
                for (int i = 0; i < valuesList.size(); i++) {
                    insertValue(tableInfo.getName(),tableInfo.getXML(), (Map) valuesList.get(i));
                }
            }
        }
        return 0;
    }

    public void insertValue(String tableName,String xml,Map map){
        CreatTableUtil creatTableUtil = new  CreatTableUtil();
        Session newSession = creatTableUtil.getSession(entityManagerFactory,xml);
        SessionImpl session = (SessionImpl) newSession;
        EntityPersister entityPersister = session.getEntityPersister(tableName, map);
        Type[] propertyTypes = entityPersister.getPropertyTypes();
        String[] propertyNames = entityPersister.getEntityPersister().getPropertyNames();
        Object[] propertyValuesToInsert = entityPersister.getPropertyValuesToInsert(map, null, session);
        for (int i = 0; i < propertyValuesToInsert.length; i++) {
            Object value = propertyValuesToInsert[i];
            Type propertyType = propertyTypes[i];
            //先将Type转为java类
            if (propertyType instanceof TimestampType){
                try {
                    Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String) value);
                    map.put(propertyNames[i],parse);
                } catch (ParseException e) {
                    e.printStackTrace(); }
            }
            if (propertyType instanceof IntegerType){
                //然后调用强转方法
                int i1 = Integer.parseInt(propertyNames[i]);
                map.put(propertyNames[i],i1);

            }
            if (propertyType instanceof StringType){
            //然后调用强转方法
                propertyNames[i]=propertyNames[i]+"";
                map.put(propertyNames[i],propertyNames[i]);
            }
        }
        newSession.saveOrUpdate(tableName,map);
    }
}
