package com.tykj.workflowcore.model_layer.utils;


import com.tykj.workflowcore.model_layer.model.ColumnVO;
import com.tykj.workflowcore.model_layer.model.TableVO;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

import javax.persistence.EntityManagerFactory;
import java.io.ByteArrayInputStream;
import java.util.EnumSet;
import java.util.List;

/**
 * @ClassName CreatTableUtil
 * @Description TODO
 * @Author WWW
 * @Date 2021/3/1 14:35
 * @Version 1.0
 */

public class CreatTableUtil {



    public static String CreatTable(TableVO tableVO){

        List<ColumnVO> dataList = tableVO.getDataList();
        String XML_MAPPING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + tableVO.getModelName() + "\" table=\"" + tableVO.getModelName() + "\">\n";

        XML_MAPPING += " <id name=\"id\" type=\"java.lang.Long\" length=\"64\" unsaved-value=\"null\">\n" +
                "            <generator class=\"identity\" />\n" +
                "        </id>";
        for (ColumnVO columnVO : dataList) {
            XML_MAPPING +=
                    " <property type=\"" + columnVO.getFiledType() + "\" name=\"" + columnVO.getFieldName() +
                            "\" column=\"" + columnVO.getFieldName() + "\"/>\n";

        }

        XML_MAPPING += "    </class>" +
                "</hibernate-mapping>";

        return XML_MAPPING;
    }


    public Session getSession(EntityManagerFactory entityManagerFactory,String XML){

        SessionFactory sessionFactory = entityManagerFactory.unwrap(SessionFactory.class);
        StandardServiceRegistry serviceRegistry = sessionFactory.getSessionFactoryOptions().getServiceRegistry();
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        sessionFactory.getSessionFactoryOptions();
        metadataSources.addInputStream(new ByteArrayInputStream(XML.getBytes()));
        Metadata metadata = metadataSources.buildMetadata();
        //更新数据库Schema,如果不存在就创建表,存在就更新字段,不会影响已有数据
        SchemaUpdate schemaUpdate = new SchemaUpdate();
        schemaUpdate.execute(EnumSet.of(TargetType.DATABASE), metadata, serviceRegistry);

        metadata = metadataSources.buildMetadata();
        //创建会话工厂
        SessionFactory newSessionFactory = metadata.buildSessionFactory();
        //保存对象
        Session newSession = newSessionFactory.openSession();

        return newSession;
    }
}
