package com.tykj.workflowcore;

import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.io.File;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class Comm
 * @packageName com.tykj.workflwcore
 **/
@Component
public class WorkflowCoreRunner implements CommandLineRunner {

    @Bean
    ClassLoader initClassLoader(){
        return getClass().getClassLoader();
    }

    @Override
    public void run(String... args) {
        System.out.println("核心成功启动");
        //创建xml文件夹  如果不存在的话
        createXmlMkdir();
    }

    public void createXmlMkdir(){
        File file = new File(this.getClass().getClassLoader().getResource("").getPath()+"\\xml");
        if (!file.exists()){
            file.mkdir();
        }
    }



}
