package com.tykj.workflowcore.model_layer.utils;

import sun.net.www.protocol.jar.JarURLConnection;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.*;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * @ClassName ClassScan
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/22 13:44
 * @Version 1.0
 */
public class ClassScanUtil {
    private void loadClassByPath(String root, String path, List<Class<?>> list, ClassLoader load) {
        File f = new File(path);
        if (root == null) root = f.getPath();
        //判断是否是class文件
        if (f.isFile() && f.getName().matches("^.*\\.class$")) {
            try {
                String classPath = f.getPath();
                //截取出className 将路径分割符替换为.（windows是\ linux、mac是/）
                String className = classPath.substring(root.length() + 1, classPath.length() - 6).replace('/', '.').replace('\\', '.');
                list.add(load.loadClass(className));
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            File[] fs = f.listFiles();
            if (fs == null) return;
            for (File file : fs) {
                loadClassByPath(root, file.getPath(), list, load);
            }
        }
    }
    public List<Class<?>> loadClassByLoader(ClassLoader load) {
        List<Class<?>> classes = new ArrayList<>();
        try {
            Enumeration<URL> urls = load.getResources("");
            //放所有类型
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                //文件类型（其实是文件夹）
                if (url.getProtocol().equals("file")) {
                    loadClassByPath(null, url.getPath(), classes, load);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }
}
