package com.tykj.workflowcore.workflow_editer.service;

import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.vo.FlowsInfoVo;
import com.tykj.workflowcore.workflow_editer.vo.PageVo;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName:    FlowInfoService
 * Package:    com.tykj.service
 * Description: 流程
 * Datetime:    2021/2/24   10:02
 *
 * @Author: zsp
 */
public interface FlowInfoService {

    /**
     * 查询所有流程
     * @param pageVo 分页
     * @return 返回所有的流程
     */
    Page<FlowsInfo> getAllFlowsInfo(@RequestBody PageVo pageVo);

    /**
     * 查看已经部署的流程
     * @return
     */
     List<FlowsInfo> getDeployedFlowsInfo();
    /**
     * 根据id查询出一个flowsInfo对象
     * @param id flowInfo Id
     * @return FlowInfo对象
     */
    FlowsInfo findById(Long id);

    /**
     * 根据流程主键修改
     * @param flowsInfoVo flowsInfo
     * @return flowsInfoVo
     */
    FlowsInfo findByFlowName(@RequestBody FlowsInfoVo flowsInfoVo);

    /**
     * 根据流程描述修改
     * @param flowsInfoVo flowsInfo
     * @return flowsInfoVo
     */
    FlowsInfo findByDesc(@RequestBody FlowsInfoVo flowsInfoVo);

    /**
     * 根据流程部署id查询
     * @param deployId 部署id
     * @return flowsInfo
     */
    FlowsInfo findByDeployId(String deployId);

    /**
     * 根据id删除
     * @param id id
     */
    void deleteById(Long id);

    /**
     * 根据流程主键查询
     * @param flowKey 流程主键
     * @return flowsInfo 对象
     */
    FlowsInfo findByFlowKey(String flowKey);

}
