package com.tykj.workflowcore.workflow_editer.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author zsp
 * @version V1.0
 * @class WebMvcConfig
 * @packageName com.example.personnelmanager.common.config
 * @data 2020/6/11
 **/

@Configuration
public class WebMvcConfig  {

    @Value("${file.path}")
    String filePath;

@Bean
public WebMvcConfigurer corsConfigurer() {
    return new WebMvcConfigurer() {
        @Override
        public void addCorsMappings(CorsRegistry registry) {
            registry.addMapping("/**")
                    .allowedOriginPatterns("*")
                    .allowCredentials(true)
                    .allowedMethods("GET", "POST", "DELETE", "PUT","PATCH")
                    .maxAge(3600);
        }
        /*
         * 静态资源配置
        **/
        @Override
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler("/file/**").addResourceLocations("file:" + filePath);
        }
    };
}

}
