package com.tykj.workflowcore.workflow_editer.service.impl;

import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.mapper.FlowsInfoMapper;
import com.tykj.workflowcore.workflow_editer.service.FlowInfoService;
import com.tykj.workflowcore.workflow_editer.vo.FlowsInfoVo;
import com.tykj.workflowcore.workflow_editer.vo.PageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName:    FlowInfoServiceImpl
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/2/24   10:15
 *
 * @Author: zsp
 */
@Service
public class FlowInfoServiceImpl implements FlowInfoService {

    @Autowired
    private FlowsInfoMapper flowsInfoMapper;
    @Override
    public Page<FlowsInfo> getAllFlowsInfo(@RequestBody PageVo pageVo) {
        PageRequest pageRequest = PageRequest.of(pageVo.getPageNum()+1, pageVo.getPageSize());
        return  flowsInfoMapper.findAll(pageRequest);
    }

    @Override
    public List<FlowsInfo> getDeployedFlowsInfo() {

        FlowsInfo flowsInfo = new FlowsInfo();
        flowsInfo.setState(0);

        Specification<FlowsInfo> state = Specifications.<FlowsInfo>and().eq("state", flowsInfo.getState()).build();

        return flowsInfoMapper.findAll(state);

    }


    @Override
    public FlowsInfo findById(Long id) {
        return flowsInfoMapper.findById(id).get();
    }

    @Override
    public FlowsInfo findByFlowName(@RequestBody FlowsInfoVo flowsInfoVo) {
        String flowKey = flowsInfoVo.getFlowKey();
        String flowName = flowsInfoVo.getFlowName();
        FlowsInfo flowsInfo = flowsInfoMapper.findByFlowKey(flowKey);
        flowsInfo.setFlowName(flowName);
        //进行更新
        FlowsInfo newFlowsInfo = flowsInfoMapper.save(flowsInfo);
        return newFlowsInfo;
    }

    @Override
    public FlowsInfo findByDesc(@RequestBody FlowsInfoVo flowsInfoVo) {

        String flowKey = flowsInfoVo.getFlowKey();
        String describe = flowsInfoVo.getFlowDescribe();
        FlowsInfo byDesc = flowsInfoMapper.findByFlowKey(flowKey);
        byDesc.setFlowDescribe(describe);
//        //进行更新
//        FlowsInfo flowsInfo = flowsInfoMapper.save(byDesc);
        return flowsInfoMapper.save(byDesc);
    }
}
