package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.mapper.FormPageMapper;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
import com.tykj.workflowcore.workflow_editer.vo.FormPageVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import springfox.documentation.swagger2.mappers.ModelMapper;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName:    PageEntityServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   13:16
 *
 * @Author: zsp
 */
@Service
public class FormPageServiceImpl implements FormPageService {

    @Autowired
    private FormPageMapper formPageMapper;

    @Override
    public Long savePage(@RequestBody FormPage formPage) {
        FormPage formPage1 = formPageMapper.save(formPage);
        Long id = formPage1.getId();
        return id;
    }

    @Override
    public FormPageVo getPage(@PathVariable("id") Long id) {

        FormPage formPage = formPageMapper.findById(id).get();
        FormPageVo formPageVo= new FormPageVo();
        BeanUtils.copyProperties(formPage,formPageVo);
        return formPageVo;
    }

    @Override
    public void deletePage(@PathVariable("id") Long id) {
        formPageMapper.deleteById(id);
    }

    @Override
    public List<FormPageVo> getAllPages() {


        ArrayList<FormPageVo> formPageVos = new ArrayList<>();
        List<FormPage> formPages = formPageMapper.findAll();
        for (FormPage formPage : formPages) {
            FormPageVo formPageVo = new FormPageVo();
            BeanUtils.copyProperties(formPage,formPageVo);
            formPageVos.add(formPageVo);
        }
        return formPageVos;
    }


}
