package com.tykj.workflowcore.api.controller;

import com.tykj.workflowcore.api.entity.ClassInfo;
import com.tykj.workflowcore.api.service.ApiService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController("/api/info")
public class ApiController {

    private final ApiService apiService;

    public ApiController(ApiService apiService) {
        this.apiService = apiService;
    }

    @GetMapping
    public ResponseEntity<List<ClassInfo>> findAll(){
        return ResponseEntity.ok(apiService.findAll());
    }

}
