package com.tykj.workflowcore.workflow_editer.service;

import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.vo.FormPageVo;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName:    PageEntityService
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/3/3   13:14
 *
 * @Author: zsp
 */
public interface FormPageService {

    /**
     * 保存页面
     * @param formPage 页面实体
     * @return 主键id
     */
    Long savePage(@RequestBody FormPage formPage);

    /**
     * 根据页面id来进行回显
     * @param id 页面id
     * @return 页面信息
     */
    FormPageVo getPage(@PathVariable("id") Long id);

    /**
     * 根据页面id删除页面
     * @param id 页面id
     */
    void deletePage(@PathVariable("id") Long id);

    /**
     * 查询全部页面
     * @return 全部集合
     */
    List<FormPageVo> getAllPages();

}
