package com.tykj.workflowcore.model_layer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.*;

/**
 * @ClassName ColumnInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:14
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Entity
@Data
@SQLDelete(sql = "update column_info set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
public class ColumnInfo extends BaseEntity {

    /**
     * 是否primary key， 0是，1否
     */
    @ApiModelProperty("是否主键")
    private Integer primaryKey;

    @ApiModelProperty("列名")
    private String fieldName;

    @ApiModelProperty("修改后的新列名")
    private String NewFieldName;

    @ApiModelProperty("列名中文描述")
    private String fieldTitle;
    @ApiModelProperty("列类型")
    private String fieldType;
    @ApiModelProperty("长度")
    private Integer fieldLength;
    @ApiModelProperty("所属表名")
    private String dbName;
    @ApiModelProperty("所属表id")
    private Integer dbId;



}
