package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.workflow_editer.vo.InFormPageVo;
import com.tykj.workflowcore.workflow_editer.vo.OutFormPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import javax.persistence.*;
import java.util.Date;

/**
 * ClassName:    FormPage
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/3/3   10:32
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Api("表单页面")
public class FormPage {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("页面名称")
    private String pageName;

    @ApiModelProperty("页面描述")
    private String pageDesc;

    @ApiModelProperty("模板")
    @Lob
    private String template;

    @ApiModelProperty("页面js")
    @Lob
    private String js;

    @ApiModelProperty("页面css")
    @Lob
    private String css;

    @ApiModelProperty("创建的时间")
    private Date createTime;

    @ApiModelProperty("修改的时间")
    private Date updateTime;

    @ApiModelProperty("json描述文件")
    private String descFile;

    @ApiModelProperty("实体类id")
    private String entityId;

    public OutFormPageVo toEntityVo(){
        OutFormPageVo outFormPageVo = new OutFormPageVo();
        BeanUtils.copyProperties(this,outFormPageVo);
        return outFormPageVo;
    }
}
