package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.model_layer.annotatiion.WorkFlowCoreNoScan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

/**
 * ClassName:    FlowsInfo
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/2/23   10:12
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@WorkFlowCoreNoScan
@Api("流程表")
public class FlowsInfo {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("流程id")
    private Long id;

    @ApiModelProperty("发起人的Id")
    private Long userId;

    @ApiModelProperty("发起人的名字")
    private Long userName;

    @ApiModelProperty("流程名称")
    private String flowName;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("流程主键")
    private String flowKey;

    @ApiModelProperty(value = "部署状态",notes = "0 已部署，1 未部署")
    private Integer state;

    @ApiModelProperty("文件路径")
    private String filePath;

    @ApiModelProperty("流程创建时间")
    private Date createTime;

    @ApiModelProperty("流程修改时间")
    private Date updateTime;

    @ApiModelProperty("流程描述")
    private String flowDescribe;

    @ApiModelProperty("开始节点的id")
    private String startId;
    /**
    * @Description:
    * @params: 部署id
    */
    private String deployId;
}
