package com.tykj.workflowcore.workflow_editer.service.impl;


import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.mapper.FormPageMapper;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
import com.tykj.workflowcore.workflow_editer.vo.InFormPageVo;
import com.tykj.workflowcore.workflow_editer.vo.OutFormPageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * ClassName:    PageEntityServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   13:16
 *
 * @Author: zsp
 */
@Service
public class FormPageServiceImpl implements FormPageService {

    @Autowired
    private FormPageMapper formPageMapper;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Override
    public Long savePage(@RequestBody InFormPageVo inFormPageVo) {
        inFormPageVo.setCreateTime(new Date());
        FormPage formPage = inFormPageVo.toEntity();
        FormPage formPage1 = formPageMapper.save(formPage);
        Long id = formPage1.getId();
        return id;
    }

    @Override
    public void update(FormPage formPage) {
        formPageMapper.save(formPage);
    }

    @Override
    public FormPage getPage(@PathVariable("id") Long id) {

        FormPage formPage = formPageMapper.findById(id).get();
        //时间排序
        return formPage;
    }

    @Override
    public void deletePage(@PathVariable("id") Long id) {
        formPageMapper.deleteById(id);
    }

    @Override
    public List<OutFormPageVo> getAllPages() {

        ArrayList<OutFormPageVo> formPageVos = new ArrayList<>();
        List<FormPage> formPages = formPageMapper.findAll();
        for (FormPage formPage : formPages) {
//            FormPageVo formPageVo = new FormPageVo();
//            BeanUtils.copyProperties(formPage,formPageVo);
//            formPageVos.add(formPageVo);
            OutFormPageVo outFormPageVo = formPage.toEntityVo();
            formPageVos.add(outFormPageVo);
        }
        return formPageVos;
    }

        @Override
    public List<TableInfo> findByPageIds(List<Long> pageIds) {
        ArrayList<TableInfo> list = new ArrayList<>();
        for (Long pageId : pageIds) {
            //通过pageId 查询出表id
            String entityId = formPageMapper.findById(pageId).get().getEntityId();
            //根据entityId查询出表
            PredicateBuilder<TableInfo> builder = Specifications.and();
            builder.eq("id",entityId);
            List<TableInfo> tableInfoList = tableInfoDao.findAll(builder.build());
            list.addAll(tableInfoList);
        }
        return list;
    }

}
