package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.api.entity.InvokeRequest;
import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.service.FlowInfoService;
import com.tykj.workflowcore.workflow_editer.service.WorkFlowService;
import com.tykj.workflowcore.workflow_editer.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.flowable.task.api.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * ClassName:    WorkFlowController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/2   9:48
 *
 * @Author: zsp
 */
@Api("工作流管理接口")
@RestController
@RequestMapping("/workFlow")
public class WorkFlowController {

    @Autowired
    private FlowInfoService flowInfoService;

    @Autowired
    private WorkFlowService workFlowService;
    @PostMapping("/deploy")
    @ApiOperation(value = "部署流程",notes = "0 部署成功")
    public Integer deploy(Long id) throws FileNotFoundException {
        //根据id 查询出flowsInfo
        FlowsInfo flowsInfo = flowInfoService.findById(id);
        if (flowsInfo.getState() == 0){
            return 0;
        }
        workFlowService.deployXml(flowsInfo);
        return flowsInfo.getState();
    }

    @PostMapping("/startFlow")
    @ApiOperation("开启流程")
    public String startFlow(@RequestBody StartFlowVo startFlowVo){
        workFlowService.startFlow(startFlowVo);
        return null;
    }

    @PostMapping("/findUserTask")
    @ApiOperation("任务个人待办列表")
    public List<Map<String,Object>> findUserTask(@RequestBody NextTaskVo nextTaskVo){

        return workFlowService.findTaskByUserId(nextTaskVo);

    }

    @PostMapping("/findTaskDetail")
    @ApiOperation("任务个人待办详情")
    public Map<String, Object> findTaskDetail(String taskId){
        return  workFlowService.findTaskDetail(taskId);
    }

    @PostMapping("/completeTask")
    @ApiOperation("完成任务")
    public ResponseEntity completeTask(@RequestBody TaskVo taskVo){
        workFlowService.completeTask(taskVo);
        return ResultUtil.success("该任务已完成");
    }

    @PostMapping("/isTransferTask")
    @ApiOperation("是否转交任务")
    public ResponseEntity isTransferTask(@RequestBody TransferTask transferTask){
        workFlowService.transferTask(transferTask);
        return ResultUtil.success("该任务转交成功");
    }

    @PostMapping("/isSuspension")
    @ApiOperation("是否挂起")
    public ResponseEntity isSuspension(@RequestBody SuspendVo suspendVo){
        workFlowService.suspendOrActivateProcessDefinitionByKey(suspendVo);
        return ResultUtil.success("该流程已被挂起");
    }

    @DeleteMapping("/deleteFlow")
    @ApiOperation("是否删除")
    public ResponseEntity deleteFlow(String deployId){
        //根据流程id查询出flowsInfo
        FlowsInfo flowsInfo = flowInfoService.findByDeployId(deployId);
        //删除flowsInfo
        flowInfoService.deleteById(flowsInfo.getId());
        workFlowService.deleteFlow(deployId);
        return ResultUtil.success("该流程已被删除");
    }

    @PostMapping("/flowProgress")
    @ApiOperation("流程进度")
    public void flowProgress(@RequestBody FlowProcessVo flowProcessVo) throws IOException {
        workFlowService.flowProgress(flowProcessVo.getResponse(),flowProcessVo.getProcessInstanceId());
    }

    @PostMapping("/findHistoryTask")
    @ApiOperation("已办任务")
    public List findHistoryTask(String userId) {
       return workFlowService.findHistoryTask(userId);
    }

}
