package com.tykj.workflowcore.workflow_editer.entity.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class NodeInfoVo
 * @packageName com.tykj.workflowcore.workflow_editer.entity.vo
 **/
@AllArgsConstructor
@NoArgsConstructor
@Data
public class NodeInfoVo {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("节点id")
    private String nodeId;

    @ApiModelProperty("页面id")
    private long pageId;

    @ApiModelProperty("流程key")
    private String flowKey;

    @ApiModelProperty("流程名")
    private String flowName;

    @ApiModelProperty("0为默认,1为可视,2为公式")
    private Integer type;

    @ApiModelProperty("输入框中的值  例如： 同意，不同意")
    private Integer value;

    @ApiModelProperty("连接条件")
    private String connectionConditions;

    @ApiModelProperty("判断条件拼接字段  例如：[{'resource':'${people.id}','comparator':'>=','value':'10'}]")
    private String expressionCondition;


}
