package com.tykj.workflowcore.workflow_editer.service.impl;

import com.tykj.workflowcore.workflow_editer.entity.NodeInfo;
import com.tykj.workflowcore.workflow_editer.mapper.NodePageMapper;
import com.tykj.workflowcore.workflow_editer.service.NodeInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * ClassName:    NodePageServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/4   15:34
 *
 * @Author: zsp
 */
@Service
public class NodeInfoServiceImpl implements NodeInfoService {

    @Autowired
    private NodePageMapper nodePageMapper;
    @Override
    public Long findByNodeId(String nodeId) {
        return nodePageMapper.findByNodeId(nodeId);
    }

    @Override
    public void saveNodePage(NodeInfo nodeInfo) {

       nodePageMapper.save(nodeInfo);
    }

    @Override
    public void saveNodeInfoList(List<NodeInfo> nodeInfos) {
        if (nodeInfos!=null){
            nodePageMapper.saveAll(nodeInfos);
        }
    }
}
