package com.tykj.workflowcore.workflow_editer.service;

import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.vo.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * ClassName:    FlowableService
 * Package:    com.tykj.service
 * Description:工作流服务接口
 * Datetime:    2021/2/23   9:49
 *
 * @Author: zsp
 */

public interface WorkFlowService {


    /**
     * 保存流程文件
     * @param file file文件
     * @return 路径名称
     */
    String saveXml(@RequestParam("file") MultipartFile file);

    /**
     * 接收前端的流程文件
     * @param flowsInfoVo
     */
    void flowXml(@RequestBody FlowsInfoVo flowsInfoVo);

    /**
     * 创建流程
     * @param flowsInfo
     * @return 主键id
     */
    Long createFlow(@RequestBody FlowsInfo flowsInfo);

    /**
     * 部署xml流程文件
     * @param flowsInfo
     * @throws FileNotFoundException
     */
    void deployXml(FlowsInfo flowsInfo) throws FileNotFoundException;

    /**
     * 存储变量池  选择变量条件
     * @param map
     * @return map
     */
    Map<String,Object> setVariables(@RequestBody Map<String, Object> map);

    /**
     * 开启流程
     * @param startFlowVo 流程开启vo
     */

    void startFlow(@RequestBody StartFlowVo startFlowVo);

    /**
     * 根据用户id进行任务待办查询
     * @param nextTaskVo
     * @return 任务列表
     */
    List<Map<String,Object>> findTaskByUserId(NextTaskVo nextTaskVo);

    /**
     * 查看具体的任务详情
//     * @param detailTaskVo 任务详情
     * @return 任务列表
     */
//    Map<String,Object> findTaskDetail(DetailTaskVo detailTaskVo);

    /**
     * 查看具体的任务详情
     * @param taskId 任务id
     * @return 任务列表
     */
    Map<String,Object> findTaskDetail(String taskId);

    /**
     *  任务完成
     * @param taskVo taskVo
     */
    void completeTask(@RequestBody TaskVo taskVo);

    /**
     * 任务的拾取 相当变成了任务的执行人 只有执行人才可以完成任务
     * @param taskId 任务Id
     * @param userId 用户Id
     */

    void claimTask(String taskId, Long userId);
    //历史查询


    /**
     * 任务的转交
     * @param transferTask
     */
    void transferTask(TransferTask transferTask);

    /**
     * 是否挂起
     * @param id 流程id
     */
    void suspendOrActivateProcessDefinitionByKey(Long id);

    /**
     * 删除流程
     * @param id 流程id
     */
    void deleteFlow(Long id);


    /**
     * 流程的进度
     * @param httpServletResponse
     * @param processId 流程实例id
     */
    void flowProgress (HttpServletResponse httpServletResponse, String processId) throws IOException;

    /**
     * 查已办任务
     * @param userId 用户id
     * @return 任务已办列表
     */
    List<Object> findHistoryTask(String userId);


}

