package com.tykj.workflowcore.workflow_editer.vo;

import com.tykj.workflowcore.base.page.JpaCustomOrder;
import com.tykj.workflowcore.base.page.JpaCustomPage;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import java.util.Date;
import java.util.List;

/**
 * ClassName:    FormPageVo
 * Package:    com.tykj.vo
 * Description:
 * Datetime:    2021/3/3   13:32
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OutFormPageVo {

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("页面名称")
    private String pageName;

    @ApiModelProperty("页面描述")
    private String pageDesc;

    @ApiModelProperty("创建的时间")
    private Date createTime;

    @ApiModelProperty("修改的时间")
    private Date updateTime;

    public FormPage toEntity(){
        FormPage formPage = new FormPage();
        BeanUtils.copyProperties(this,formPage);
        return formPage;
    }


}
