package com.tykj.workflowcore.model_layer.utils;

import java.util.List;
import java.util.Objects;

public class HqlUtil {

    public static String createQuery(String tableName, List<QueryCondition> conditions) {
        StringBuilder result = new StringBuilder("select * from table ");
        result.append(tableName);
        if (Objects.nonNull(conditions) && !conditions.isEmpty()) {
            result.append(" where ");
            for (QueryCondition condition : conditions) {
                result.append(condition.getName()).append(condition.getType()).append(condition.getValue()).append(" AND ");
            }
            result.delete(result.lastIndexOf(" AND "), result.length());
        }
        return result.toString();
    }

}
