package com.tykj.workflowcore.workflow_editer.service.impl;


import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.dao.FormPageMapper;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
import com.tykj.workflowcore.workflow_editer.entity.vo.InFormPageVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.PageFormPageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * ClassName:    PageEntityServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   13:16
 *
 * @Author: zsp
 */
@Service
public class FormPageServiceImpl implements FormPageService {

    @Autowired
    private FormPageMapper formPageMapper;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Override
    public Integer savePage(@RequestBody InFormPageVo inFormPageVo) {
        inFormPageVo.setCreateTime(new Date());
        FormPage formPage = inFormPageVo.toEntity();
        FormPage formPage1 = formPageMapper.save(formPage);
        Integer id = formPage1.getId();
        return id;
    }

    @Override
    public void update(FormPage formPage) {
        formPageMapper.save(formPage);
    }

    @Override
    public FormPage getPage(@PathVariable("id") Integer id) {

        FormPage formPage = formPageMapper.findById(id).get();
        //时间排序
        return formPage;
    }

    @Override
    public void deletePage(Integer id) {
        FormPage formPage = formPageMapper.findById(id).get();
        formPage.setDeleted(1);
        formPageMapper.save(formPage);
    }

    @Override
    public Page<FormPage> getAllPages(PageFormPageVo pageFormPageVo) {

        PredicateBuilder<FormPage> and = Specifications.and();
        and.eq(pageFormPageVo.getPageName()!=null,"pageName",pageFormPageVo.getPageName());
        and.eq(pageFormPageVo.getPageDesc()!=null,"pageDesc",pageFormPageVo.getPageDesc());
        and.eq(pageFormPageVo.getCreateTime()!=null,"createTime",pageFormPageVo.getCreateTime());

        Page<FormPage> formPagePage = formPageMapper.findAll(and.build(), pageFormPageVo.getPageable());

        return formPagePage;
    }

        @Override
    public List<TableInfo> findByPageIds(List<Integer> pageIds) {
        ArrayList<TableInfo> list = new ArrayList<>();
        for (Integer pageId : pageIds) {
            //通过pageId 查询出表id
            String entityId = formPageMapper.findById(pageId).get().getEntityId();
            //根据entityId查询出表
            PredicateBuilder<TableInfo> builder = Specifications.and();
            builder.eq("id",entityId);
            List<TableInfo> tableInfoList = tableInfoDao.findAll(builder.build());
            list.addAll(tableInfoList);
        }
        return list;
    }

}
