package com.tykj.workflowcore.workflow_editer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tykj.workflowcore.api.entity.InvokeRequest;
import com.tykj.workflowcore.api.entity.Parameter;
import com.tykj.workflowcore.api.service.SpringBeanService;
import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.base.util.FileUtil;
import com.tykj.workflowcore.workflow_editer.entity.*;
import com.tykj.workflowcore.workflow_editer.dao.FlowsInfoMapper;
import com.tykj.workflowcore.workflow_editer.entity.vo.*;
import com.tykj.workflowcore.workflow_editer.service.NodeInfoService;
import com.tykj.workflowcore.workflow_editer.service.UserService;
import com.tykj.workflowcore.workflow_editer.service.VariableStorageService;
import com.tykj.workflowcore.workflow_editer.service.WorkFlowService;
import com.tykj.workflowcore.workflow_editer.util.UserServiceBeanUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.flowable.bpmn.model.*;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.*;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.image.ProcessDiagramGenerator;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;
import java.util.regex.Pattern;

/**
 * ClassName:    FlowableServiceImpl
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/2/23   13:46
 *
 * @Author: zsp
 */
@Service
public class WorkFlowServiceImpl implements WorkFlowService {

    private final RepositoryService repositoryService;
    private final RuntimeService runtimeService;
    private final TaskService taskService;
    private final FlowsInfoMapper flowsInfoMapper;
    private final UserService userService;
    private final HistoryService historyService;
    private final ProcessEngineConfigurationImpl processEngineConfiguration;
    private final ProcessEngine processEngine;

    private final VariableStorageService variableStorageService;

    final
    ClassLoader classLoader;

    @Autowired
    NodeInfoService nodeInfoService;

    public WorkFlowServiceImpl(SpringBeanService springBeanService, HistoryService historyService, RepositoryService repositoryService, RuntimeService runtimeService, TaskService taskService, FlowsInfoMapper flowsInfoMapper, ProcessEngineConfigurationImpl processEngineConfiguration, ProcessEngine processEngine, VariableStorageService variableStorageService, ClassLoader classLoader) {
        this.historyService = historyService;
        this.repositoryService = repositoryService;
        this.runtimeService = runtimeService;
        this.taskService = taskService;
        this.flowsInfoMapper = flowsInfoMapper;
        this.userService = UserServiceBeanUtil.getUserService(springBeanService);
        this.processEngineConfiguration = processEngineConfiguration;
        this.processEngine = processEngine;
        this.variableStorageService = variableStorageService;
        this.classLoader = classLoader;
        System.out.println(userService != null ? "成功" : "失败");
    }

    @Override
    public String saveXml(@RequestParam("file") MultipartFile file) {

        String realPath = null;
        if (!file.isEmpty()) {
            //获取文件名
            String fileName = file.getOriginalFilename();
            System.out.println(fileName);
            //获取文件后缀
            String suffixName = Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));
            //重新生成文件名
            fileName = UUID.randomUUID() + suffixName;
            System.out.println(fileName);
            //指定本地存入路径
            File fileNew = new File(classLoader.getResource("").getPath() + fileName);
            realPath = classLoader.getResource("").getPath() + fileName;
            try {
                file.transferTo(fileNew);
            } catch (IOException e) {
                e.printStackTrace();
            }

            //解析xml
            //1.创建Reader对象
            SAXReader reader = new SAXReader();
            //2.加载xml
            Document document = null;
            try {
                document = reader.read(fileNew);
            } catch (DocumentException e) {
                e.printStackTrace();
            }
            //3.获取根节点
            Element rootElement = document.getRootElement();
            Iterator iterator = rootElement.elementIterator();
            String processId = null;
            String processName = null;
            Element stu = (Element) iterator.next();
            List<Attribute> attributes = stu.attributes();
            System.out.println("======获取属性值======");
            for (Attribute attribute : attributes) {
                if ("id".equals(attribute.getName())) {
                    processId = attribute.getValue();
                    System.out.println("processId的值是:" + processId);
                }
                if ("name".equals(attribute.getName())) {
                    processName = attribute.getValue();
                    System.out.println("processName的值是:" + processName);
                }
            }
            //保存processId和processName 到数据库里面
            FlowsInfo flowsInfo = new FlowsInfo();
            flowsInfo.setFlowKey(processId);
            flowsInfo.setFlowName(processName);
            flowsInfo.setResourceName(file.getOriginalFilename());
            //状态为未部署
            flowsInfo.setState(1);
            flowsInfo.setFilePath(realPath);
            flowsInfoMapper.save(flowsInfo);
        }
        return realPath;
    }

    @Override
    public void flowXml(@RequestBody FlowsInfoVo flowsInfoVo) {
        String basePath = System.getProperty("user.dir") + "\\xml\\";
        Integer id = flowsInfoVo.getId();
        String flowKey = flowsInfoVo.getFlowKey();
        String fileXml = flowsInfoVo.getFileXml();
        //生成xml文件

        FileUtil.createFileByString(basePath + flowKey + "bpmn20.xml", flowsInfoVo.getFileXml().replaceAll("\\[\\?\\?[^\\]]+\\?\\?\\]", ""));
        FileUtil.createFileByString(basePath + flowKey + "bpmnCustom20.xml", flowsInfoVo.getFileXml());

        FlowsInfo flowsInfo = new FlowsInfo();
        BeanUtils.copyProperties(flowsInfoVo, flowsInfo);
        flowsInfo.setResourceName(flowKey + "bpmn20.xml");
        flowsInfo.setFilePath("\\xml\\" + flowKey + "bpmn20.xml");
        flowsInfo.setFileCustomPath("\\xml\\" + flowKey + "bpmnCustom20.xml");
        flowsInfo.setId(id);
        //更新并保存
        FlowsInfo save = flowsInfoMapper.save(flowsInfo);
        //自动部署
        deployXml(save);
    }


    @Override
    public Integer createFlow(FlowsInfo flowsInfo) {
        FlowsInfo flowsInfo1 = flowsInfoMapper.save(flowsInfo);
        return flowsInfo1.getId();
    }


    @Override
    public void deployXml(FlowsInfo flowsInfo) {
        Deployment deploy = null;
        try {
            deploy = repositoryService.createDeployment().addInputStream(System.getProperty("user.dir") + flowsInfo.getResourceName(),
                    new FileInputStream(System.getProperty("user.dir") + flowsInfo.getFilePath())).deploy();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        //修改状态
        flowsInfo.setState(0);
        flowsInfo.setDeployId(deploy.getId());
        flowsInfoMapper.save(flowsInfo);

    }

    @Override
    public void startFlow(@RequestBody StartFlowVo startFlowVo) {

        //设置流程发起人
        WorkFlowUser currentUser = userService.getCurrentUser();

        Authentication.setAuthenticatedUserId(currentUser.getId() + "");

        ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(startFlowVo.getFlowKey(),
                startFlowVo.getMap());
        //存储流程实例id
        //根据flowKey查询出一个FlowInfo
        FlowsInfo flowsInfo = flowsInfoMapper.findByFlowKey(startFlowVo.getFlowKey());
        flowsInfo.setProcessInstanceId(processInstance.getProcessInstanceId());
        flowsInfoMapper.save(flowsInfo);
    }


    @Override
    public List<Map<String, Object>> findTaskByUserId(NextTaskVo nextTaskVo) {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        TaskQuery taskQuery = taskService.createTaskQuery();
        if (nextTaskVo.getRoleId() != null || nextTaskVo.getUserId() != null) {
            taskQuery.or();
            if (nextTaskVo.getUserId() != null) {
                taskQuery.taskCandidateUser(nextTaskVo.getUserId()).orderByTaskCreateTime().desc();
            }
            if (nextTaskVo.getRoleId() != null && nextTaskVo.getRoleId().size() > 0) {
                taskQuery.taskCandidateGroupIn(nextTaskVo.getRoleId()).orderByTaskCreateTime().desc();
            }
            taskQuery.endOr();
        }
        List<Task> listTask = taskQuery.list();
        for (Task task : listTask) {
            Map<String, Object> map = new HashMap<>();
            ProcessInstance processInstance =
                    runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            //节点id
            String taskDefinitionKey = task.getTaskDefinitionKey();
            //通过节点id查询出pageId
            Integer currentPageId = nodeInfoService.findByNodeId(taskDefinitionKey);
            map.put("taskId", task.getId());
            map.put("processKey", processInstance.getProcessDefinitionKey());
            map.put("taskName", task.getName());
            map.put("taskDesc", task.getDescription());
            map.put("createTime", task.getCreateTime());
            map.put("promoter", processInstance.getStartUserId());
            map.put("processInstanceId", processInstance.getId());
            map.put("currentPageId", currentPageId);
            listMap.add(map);
        }
        return listMap;

    }

    @Override
    public Map<String, Object> findTaskDetail(String taskId) {
        Map<String, Object> variables = new HashMap<>();
        //流程还在运行
        if (taskId != null) {
            variables = taskService.getVariables(taskId);
        } else {
            //流程已经结束
            //从历史中查询
            HistoricTaskInstance historicTaskInstance =
                    historyService.createHistoricTaskInstanceQuery().taskId(taskId).finished().singleResult();
            variables.put("historicTaskInstance", historicTaskInstance);
        }
        return variables;
    }

    @Override
    public void completeTask(@RequestBody TaskVo taskVo) {

        Map<String, Object> map = new HashMap<>();
        if (taskVo.getMap() != null) {
            setVariables(taskVo.getMap());
        }
        Task task = taskService.createTaskQuery().taskId(taskVo.getTaskId()).singleResult();
        String processInstanceId = task.getProcessInstanceId();
        //如果 存在任务评论的话 向任务中添加任务评论
        if (taskVo.getComments() != null) {
            taskService.addComment(task.getId(), processInstanceId, taskVo.getComments());
        }
        //先判断是不是表达式
        if (taskVo.getConditionalExpression() != null) {
            claimTask(task.getId(), userService.getCurrentUser().getId());
            taskService.complete(task.getId());
        } else {
            map.put("handlingOpinion", taskVo.getHandlingOpinion());
            claimTask(task.getId(), userService.getCurrentUser().getId());
            taskService.complete(task.getId(), map);
        }
        //查询是否为最后一个节点
//        ExecutionEntity ee = (ExecutionEntity) processEngine.getRuntimeService().createExecutionQuery()
//                .executionId(task.getExecutionId()).singleResult();
//        BpmnModel bpmnModel = processEngine.getRepositoryService().getBpmnModel(task.getProcessDefinitionId());
//        FlowNode flowNode = (FlowNode) bpmnModel.getFlowElement(ee.getActivityId());
//        List<SequenceFlow> outFlows = flowNode.getOutgoingFlows();
//        for (SequenceFlow sequenceFlow : outFlows) {
//            FlowElement targetFlow = sequenceFlow.getTargetFlowElement();
//            // 如果下个审批节点为结束节点
//            if (targetFlow instanceof EndEvent) {
//                System.out.println("下一节点为结束节点：id=" + targetFlow.getId() + ",name=" + targetFlow.getName());
//            }
//        }



//        if (taskVo.getTaskId() == null){
//            //流程结束了
//            //通过processInstanceId查询出flowKey
//            FlowsInfo flowsInfo = flowsInfoMapper.findByProcessInstanceId(processInstanceId);
//            //查询调用接口的配置
//            List<VariableStorage> variableStorageList = variableStorageService.searchVariableStorageList(new SearchVariableStorageVo(flowsInfo.getFlowKey()));
//            for (VariableStorage variableStorage : variableStorageList) {
//                InvokeRequestVo variableInfo = variableStorage.getInvokeRequest();
//                //调用服务接口
//                getApiInvokeParam(variableInfo);
//            }
//        }

    }

    @Override
    public void claimTask(String taskId, Integer userId) {
        //当前登录人的Id
        taskService.claim(taskId, Integer.toString(userId));
    }

    @Override
    public void transferTask(TransferTask transferTask) {
        taskService.setAssignee(transferTask.getTaskId(), transferTask.getUserId());
    }


    @Override
    public void suspendOrActivateProcessDefinitionByKey(Integer id) {
        //通过流程ID 查询出flowsInfo
        FlowsInfo flowsInfo = flowsInfoMapper.findById(id).get();
        String flowKey = flowsInfo.getFlowKey();
        List<Deployment> list = repositoryService.createDeploymentQuery().processDefinitionKey(flowKey).list();
        if (list != null && list.size() > 0) {
            if (flowsInfo.getState() == 0) {
                //挂起
                repositoryService.suspendProcessDefinitionByKey(flowKey, true, new Date());
                flowsInfo.setState(1);
            } else {
                //激活
                repositoryService.activateProcessDefinitionByKey(flowKey, true, new Date());
                flowsInfo.setState(0);
            }
        } else {
            throw new ApiException("该流程未编辑流程图无法被启用");
        }

        flowsInfoMapper.save(flowsInfo);
    }


    @Override
    public void deleteFlow(Integer id) {
        //通过流程id查询出flowsInfo
        Optional<FlowsInfo> flowsInfoMapperById = flowsInfoMapper.findById(id);
        if (flowsInfoMapperById.isPresent()) {
            FlowsInfo flowsInfo = flowsInfoMapperById.get();
            if (flowsInfo.getState() == 0) {
                flowsInfoMapper.deleteById(id);
            }
        } else {
            throw new ApiException("流程不存在");
        }

    }

    @Override
    public void flowProgress(HttpServletResponse httpServletResponse, String processId) throws IOException {

        ProcessInstance pi = runtimeService.createProcessInstanceQuery().processInstanceId(processId).singleResult();
        //流程走完的不显示图
        if (pi == null) {
            return;
        }
        Task task = taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        //使用流程实例ID，查询正在执行的执行对象表，返回流程实例对象
        String processInstanceId = task.getProcessInstanceId();
        List<Execution> executions = runtimeService
                .createExecutionQuery()
                .processInstanceId(processInstanceId)
                .list();

        //得到正在执行的Activity的Id
        List<String> activityIds = new ArrayList<>();
        List<String> flows = new ArrayList<>();
        for (Execution exe : executions) {
            List<String> ids = runtimeService.getActiveActivityIds(exe.getId());
            activityIds.addAll(ids);
        }

        //获取流程图
        BpmnModel bpmnModel = repositoryService.getBpmnModel(pi.getProcessDefinitionId());
        ProcessEngineConfiguration engconf = processEngine.getProcessEngineConfiguration();
        ProcessDiagramGenerator diagramGenerator = engconf.getProcessDiagramGenerator();
        InputStream in = diagramGenerator.generateDiagram(bpmnModel, "png", activityIds, flows, engconf.getActivityFontName(), engconf.getLabelFontName(), engconf.getAnnotationFontName(), engconf.getClassLoader(), 1.0, true);
        OutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        } finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }

    }

    @Override
    public List<Object> findHistoryTask(String userId) {
        List<HistoricTaskInstance> taskInstanceList =
                historyService.createHistoricTaskInstanceQuery().taskAssignee(userId).finished().list();
        ArrayList<Object> arrayList = new ArrayList<>();
        arrayList.addAll(taskInstanceList);
        return arrayList;
    }

    /**
     * 获取调用Api用的参数
     *
     * @param invokeRequestVo 调用服务接口vo
     * @return 调用服务接口实体
     */
    public InvokeRequest getApiInvokeParam(InvokeRequestVo invokeRequestVo) {
        //拿出taskId
        String processInstanceId = invokeRequestVo.getProcessInstanceId();
        List<Parameter> parameterList = invokeRequestVo.getParameterList();
        List<Parameter> newParameterList = new ArrayList<>();
        for (int i = 0; i < parameterList.size(); i++) {
            Parameter parameter = parameterList.get(i);
            if (!StringUtils.isEmpty(parameter.getExp())) {
                parameter.setInstance((Map<String, Object>) getProcessValue(processInstanceId, parameter.getExp()));
            } else {
                Map<String, Object> instance = parameter.getInstance();
                JSONObject newInstance = new JSONObject();
                //遍历param的key
                Set<String> oldInstanceKey = instance.keySet();
                for (String key : oldInstanceKey) {
                    newInstance.put(key, getProcessValue(processInstanceId, (String) instance.get(key)));
                }
                parameter.setInstance(newInstance);
            }
            newParameterList.add(i, parameter);
        }
        invokeRequestVo.setParameterList(newParameterList);
        return JSONObject.parseObject(JSONObject.toJSONString(invokeRequestVo), InvokeRequest.class);
    }

    public Object getProcessValue(String processInstanceId, String exp) {
        Expression expression = processEngineConfiguration.getExpressionManager().createExpression(exp);
        ManagementService managementService = processEngine.getManagementService();
        CommandGetValue test = new CommandGetValue(processInstanceId, expression);
        Object o = managementService.executeCommand(test);
        return o;
    }

    @Override
    public Map<String, Object> setVariables(@RequestBody Map<String, Object> maxMap) {

        Map<String, Object> map = new HashMap<>();
        map.putAll(maxMap);
        return map;
    }


}
