# 工作流项目核心
## 项目简介
1. 通过可视化的方式进行流程的定制
2. 提供流程相关页面的定制
3. 提供流程相关 的接口


### 环境要求
- Maven3+
- Jdk1.8+
- springboot 2.4.1 以下 2.1.4 以上 （包含所提到的版本）

### 代码结构
```
├─src
│  ├─main
│  │  ├─java
│  │  │  └─com
│  │  │      └─tykj
│  │  │          └─workflowcore
│  │  │              ├─api  
│  │  │              ├─base --系统基础模块
│  │  │              │  ├─annotations --注解类
│  │  │              │  ├─aop 
│  │  │              │  ├─config
│  │  │              │  ├─entity
│  │  │              │  ├─page
│  │  │              │  ├─result
│  │  │              │  └─util
│  │  │              ├─model_layer --数据模型
│  │  │              │  ├─annotations 
│  │  │              │  ├─controller 
│  │  │              │  ├─dao 
│  │  │              │  ├─entity
│  │  │              │  │  └─vo
│  │  │              │  ├─service
│  │  │              │  │  └─impl
│  │  │              │  ├─util
│  │  │              ├─workflow_editor   --工作流编辑器
│  │  │              │  ├─config
│  │  │              │  ├─controller 
│  │  │              │  ├─dao 
│  │  │              │  ├─entity
│  │  │              │  │  └─vo
│  │  │              │  ├─enums
│  │  │              │  ├─listener
│  │  │              │  ├─service
│  │  │              │  │  └─impl
│  │  │              │  ├─util
│  │  │              └─WorkflowCoreApplication  --SpringBoot启动类
│  │  └─resources   --核心配置所在位置
│  │      ├─mapper
│  │      ├─template
│  │      └─ui
│  │          └─images
│  └─test
│      └─java
│          └─org
│              └─yaukie
│                  └─frame   --核心逻辑所在位置
```
## 使用方式
### 后端安装

#### maven
```
        <dependency>
            <groupId>com.tykj</groupId>
            <artifactId>workflow-core</artifactId>
            <version>0.0.1-SNAPSHOT</version>
        </dependency>
```
#### 本地引入
 1. 获取 workflow-core-0.0.1-SNAPSHOT.jar
 2. 在你自己项目的根目录下创建lib文件夹  并将 jar 包放入
 3. pom 添加 如下

```
        <dependency>
            <groupId>com.tykj</groupId>
            <artifactId>workflow-core</artifactId>
            <version>0.0.1-SNAPSHOT</version>
            <scope>system</scope>
            <systemPath>${basedir}/lib/workflow-core-0.0.1-SNAPSHOT.jar</systemPath>
        </dependency>
```
### 前端安装
```
npm install workflow-form
```
### 配置
1. 在springboot 启动类上添加注解 @EnableWorkFlowCore 
```
@EnableWorkFlowCore
@SpringBootApplication
public class DemoApplication {

    public static void main(String[] args) {
        SpringApplication.run(WorkflowCoreApplication.class, args);
    }

}
```

### 使用
1. 工作流部分

   1. 建立数据模型

      ```
      在项目启动时 工作流核心 会对带有 @Entity 注解的实体进行扫描 扫描的实体会被记录到
      ```

      

      如果需要建立一个流程需要先为该流程建立 数据模型，就像是平时开发过程中的建表操作

      例如：新建一个新增用户的流程，需要先新建一个用户对象

      

      ![image-20210315130344008](images\image-20210315130344008.png)

   2. 建立流程

      根据业务自行建立流程图

      ![image-20210315131641756](images\image-20210315131641756.png)

   3. 为节点配置页面

      ![image-20210315131723560](images\image-20210315131723560.png)

      ![image-20210315132632917](images\image-20210315132632917.png)

      

   4. 配置节点的执行人

      ```
   如下图所示,配置了节点的执行为 为 hxh_admin
      ```
   
     
   
      ![image-20210316100902054](C:\Users\admin\AppData\Roaming\Typora\typora-user-images\image-20210316100902054.png)
   
      如需要使用工作流的执行人功能请实现 UserService 
      例如：
```
@Service
@Primary
public class FlowUserServiceImpl implements UserService {

    @Override
    public WorkFlowUser getCurrentUser() {
        WorkFlowUser workFlowUser = new WorkFlowUser();
        workFlowUser.setId(1L);
        workFlowUser.setUserName("张三");
        return workFlowUser;
    }

    @Override
    public List<WorkFlowUser> getAllUser() {
        List<WorkFlowUser> workFlowUsers = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            WorkFlowUser workFlowUser = new WorkFlowUser();
            workFlowUser.setUserName("张1");
            workFlowUser.setId((long) i);
            workFlowUsers.add(workFlowUser);
        }
        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRole> getAllRole(String roleType) {
        List<WorkFlowRole> workFlowUsers = new ArrayList<>();
        if (roleType.equals("department")){
            workFlowUsers.add(new WorkFlowRole("开发部","department","1"));
            workFlowUsers.add(new WorkFlowRole("运营部","department","2"));
            workFlowUsers.add(new WorkFlowRole("测试部","department","3"));
        }else {
            workFlowUsers.add(new WorkFlowRole("管理员","role","1"));
            workFlowUsers.add(new WorkFlowRole("普通用户","role","2"));
            workFlowUsers.add(new WorkFlowRole("运维人员","role","3"));
        }

        return workFlowUsers;
    }

    @Override
    public List<WorkFlowRoleType> getRoleType() {
        List<WorkFlowRoleType> workFlowRoleTypes = new ArrayList<>();
        workFlowRoleTypes.add(new WorkFlowRoleType("部门","department"));
        workFlowRoleTypes.add(new WorkFlowRoleType("角色","role"));
        return workFlowRoleTypes;
    }

}
```
  5. 配置流程结束后的回调函数

     ```
     回调函数 需要提前写好
     例如: 新增人员流程 需要 提前写好 新增人员的接口
     当流程结束后 工作流引擎会自动对接口进行调用
     ```

     ![image-20210316104207047](C:\Users\admin\AppData\Roaming\Typora\typora-user-images\image-20210316104207047.png)

2. 宿主系统部分

   1. 查询可发起流程

      ```
      接口返回值示例
      {
          "message": "查询成功",
       "data": {
              "content": [
                  {
                      "id": 2,
                      "createdTime": "2021-03-15T03:00:48.028+00:00",
                      "updatedTime": "2021-03-15T03:10:33.009+00:00",
                      "deleted": 0,
                      "userId": null,
                      "userName": null,
                      "flowName": "测试1", 
                      "resourceName": "processId_2850e08d-0e3d-4925-93f6-adce8a9e2246bpmn20.xml",
                      "flowKey": "processId_2850e08d-0e3d-4925-93f6-adce8a9e2246",
                      //前端组件需要使用该数据
                      "state": 0,
                      "filePath": "\\xml\\processId_2850e08d-0e3d-4925-93f6-adce8a9e2246bpmn20.xml",
                      "flowDescribe": "测试2",
                      "startId": null,
                      "startPageId": 1,  //前端组件需要使用该数据
                      "processInstanceId": null,
                      "deployId": "a4c408b0-853a-11eb-81c9-d2c637ad090d"
                  },
                  {
                      "id": 3,
                      "createdTime": "2021-03-15T03:17:30.914+00:00",
                      "updatedTime": "2021-03-15T03:17:31.850+00:00",
                      "deleted": 0,
                      "userId": null,
                      "userName": null,
                      "flowName": "测试流程1",
                      "resourceName": "processId_560c6b5c-8be5-40b8-852f-8e174346e9c8bpmn20.xml",
                      "flowKey": "processId_560c6b5c-8be5-40b8-852f-8e174346e9c8",
                      "state": 0,
                      "filePath": "\\xml\\processId_560c6b5c-8be5-40b8-852f-8e174346e9c8bpmn20.xml",
                      "flowDescribe": "测试流程描述1",
                      "startId": null,
                      "startPageId": null,
                      "processInstanceId": null,
                      "deployId": "fa83de4c-853c-11eb-81c9-d2c637ad090d"
                  }
              ],
              "pageable": {
                  "sort": {
                      "sorted": false,
                      "unsorted": true,
                      "empty": true
                  },
                  "offset": 0,
                  "pageSize": 15,
                  "pageNumber": 0,
                  "paged": true,
                  "unpaged": false
              },
              "totalElements": 2,
              "last": true,
              "totalPages": 1,
              "number": 0,
              "size": 15,
              "sort": {
                  "sorted": false,
                  "unsorted": true,
                  "empty": true
              },
              "numberOfElements": 2,
              "first": true,
              "empty": false
          }
      }
      ```

   2. 渲染页面

      ```
      fromUtil.creatFrom(pageId,flowKey)
      ```

      （渲染出来的表单页面中的逻辑由工作流控制，用户完成表单所有操作后页面会自动关闭）

   3. 模拟效果

      ![image-20210315132852126](images\image-20210315132852126.png)
   
   

![image-20210315132859363](images\image-20210315132859363.png)

