package com.tykj.workflowcore.model_layer.controller;


import com.tykj.workflowcore.base.result.ResultUtil;

import com.tykj.workflowcore.model_layer.entity.vo.QueryCondition;
import com.tykj.workflowcore.model_layer.entity.vo.SearchColumnInfoVo;
import com.tykj.workflowcore.model_layer.entity.vo.SearchTableInfoVo;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.entity.vo.TableVO;
import com.tykj.workflowcore.model_layer.service.ModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelController
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:35
 * @Version 1.0
 */
@RestController
@RequestMapping("/model")
@Api("数据模型层接口")
public class ModelController {

    @Autowired
    private ModelService modelService;


    /**
     * @param
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.TableInfo>
     * @Author WWW
     * @Description 得到所有数据库信息
     * @Date 16:19 2021/3/4
     **/
    @ApiOperation("得到所有数据表信息")
    @GetMapping("/getAllEntity")
    public ResponseEntity getAllEntity(SearchTableInfoVo searchTableInfoVo) {
        Page<TableInfo> tableInfos = null;
        try {
            tableInfos = modelService.listAllEntities(searchTableInfoVo);
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }

        return ResultUtil.success(tableInfos, "");
    }

    /**
     * @param searchColumnInfoVo
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.ColumnInfo>
     * @Author WWW
     * @Description 根据表名得到所有字段名
     * @Date 16:20 2021/3/4
     **/
    @ApiOperation("根据表名获查询所有字段")
    @GetMapping("/getAllField")
    public ResponseEntity getFields(SearchColumnInfoVo searchColumnInfoVo) {
        return ResultUtil.success(modelService.showModelFields(searchColumnInfoVo), "");
    }

    /**
     * @param
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 新增数据模型
     * @Date 16:21 2021/3/4
     **/
    @ApiOperation("新增数据模型")
    @PostMapping("/addModel")
    public ResponseEntity addModel(@RequestBody TableVO tableVO) throws Exception {
        List<TableInfo> tableInfos = modelService.listAllEntities();
        for (TableInfo tableInfo : tableInfos) {
            if (tableVO.getModelName().equals(tableInfo.getName())) {
                return ResultUtil.failed("表已经存在！");
            }
        }
        modelService.newTable(tableVO);
        return ResultUtil.success("", "新建成功");

    }

    /**
     * @param map
     * @return int
     * @Author WWW
     * @Description 对应表插入数据
     * map （表名，字段数据）
     * @Date 16:22 2021/3/4
     **/
    @ApiOperation(value = "根据表名表插入数据")
    @PostMapping("/insertValues")
    public ResponseEntity insertValues(@RequestBody Map<String, Object> map) {
        modelService.putValueByEntityName(map);
        return ResultUtil.success("数据插入成功", "");

    }

    /**
     * @param tableName
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 根据表名查询所有数据
     * @Date 9:30 2021/3/11
     **/
    @ApiOperation("根据表名查询所有数据")
    @GetMapping("/getAll")
    public ResponseEntity getAll(String tableName) {
        try {
            return ResultUtil.success(modelService.findAllByName(tableName), "");
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return ResultUtil.success(null, "获取失败");
    }

    /**
     * @param tableName
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 判断表名是否重复
     * @Date 10:26 2021/3/12
     **/
    @ApiOperation("判断表名是否重复")
    @GetMapping("/checkTable")
    public ResponseEntity check(String tableName) {
        List<TableInfo> tableInfos = null;
        try {
            tableInfos = modelService.listAllEntities();
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        for (TableInfo tableInfo : tableInfos) {
            if (tableName.equals(tableInfo.getName())) {
                return ResultUtil.failed("表已经存在！");
            }
        }
        return ResultUtil.success("新建成功！");
    }

    /**
     * @param tableName
     * @param queryConditions
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 复杂查询
     * @Date 11:03 2021/3/11
     **/
    @ApiOperation("复杂查询")
    @GetMapping("/complexQuery")
    public ResponseEntity complexQuery(String tableName, List<QueryCondition> queryConditions) {

        List list = modelService.complexQuery(tableName, queryConditions);
        if (list != null) {
            return ResultUtil.success(list, "查询成功");
        }

        return ResultUtil.success(null, "没有数据");
    }
}
