package com.tykj.workflowcore.model_layer.service.impl;

import cn.hutool.db.Db;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import com.tykj.workflowcore.model_layer.dao.ColumnInfoDao;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.entity.vo.*;
import com.tykj.workflowcore.model_layer.entity.*;
import com.tykj.workflowcore.model_layer.service.ModelService;
import com.tykj.workflowcore.model_layer.utils.CreateTableUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.Session;

import org.hibernate.internal.SessionImpl;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;


import javax.persistence.Id;
import javax.persistence.criteria.*;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.tykj.workflowcore.model_layer.utils.ClassTypeLength.setLength;

import static com.tykj.workflowcore.model_layer.utils.CreateTableUtil.*;
import static com.tykj.workflowcore.model_layer.utils.HqlUtil.createQuery;


/**
 * @ClassName MoedelImpl
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:39
 * @Version 1.0
 */

@Service
@Slf4j
public class ModelImpl implements ModelService {


    @Autowired
    private EntityManagerFactory entityManagerFactory;

    @Autowired
    private TableInfoDao tableInfoDao;

    @Autowired
    private ColumnInfoDao columnInfoDao;

    /**
     * @param
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.TableInfo>
     * @Author WWW
     * @Description 得到所有表
     * @Date 16:14 2021/3/5
     **/
    @Override
    public Page<TableInfo> listAllEntities(SearchTableInfoVo searchTableInfoVo) {
        PredicateBuilder<TableInfo> and = Specifications.and();
        and.like(searchTableInfoVo.getTableName() != null, "name", "%" + searchTableInfoVo.getTableName() + "%");
        and.like(searchTableInfoVo.getTableCnName() != null, "cnName", "%" + searchTableInfoVo.getTableCnName() + "%");
        and.eq(searchTableInfoVo.getModelType()!=null,"modelType",searchTableInfoVo.getModelType());
        return tableInfoDao.findAll(and.build(), searchTableInfoVo.getPageable());

    }

    /**
     * @param SearchColumnInfoVo
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.ColumnInfo>
     * @Author WWW
     * @Description 根据表名得到所有字段名
     * @Date 16:15 2021/3/5
     **/
    @Override
    public List<ColumnInfo> showModelFields(SearchColumnInfoVo SearchColumnInfoVo) {
        PredicateBuilder<ColumnInfo> and = Specifications.and();
        and.eq(SearchColumnInfoVo.getDbId() != null, "dbId",  SearchColumnInfoVo.getDbId());
        and.eq(SearchColumnInfoVo.getDbName() != null, "dbName", SearchColumnInfoVo.getDbName());
        return columnInfoDao.findAll(and.build());
    }


    /**
     * @param tableVO
     * @return com.tykj.workflowcore.model_layer.model.TableVO
     * @Author WWW
     * @Description 完全新建一张表
     * @Date 16:16 2021/3/5
     **/
    @Override
    public TableVO newTable(TableVO tableVO) {
        String xmlMapping = createTable(tableVO);
        Integer modelType = tableVO.getModelType();
        String parentTable = null;
        //扫描新建类型
        if (modelType == 2) {
            parentTable = tableVO.getParentTable();
            tableVO.setModelType(2);
        } else {
            tableVO.setModelType(1);
        }

        CreateTableUtil creatTableUtil = new CreateTableUtil();
        Session session = creatTableUtil.getSession(entityManagerFactory, xmlMapping);

        List<ColumnVO> dataList = tableVO.getDataList();
        TableInfo tableInfo = new TableInfo();
        tableInfo.setName(tableVO.getModelName());
        tableInfo.setCnName(tableVO.getModelTitle());
        tableInfo.setXml(xmlMapping);
        tableInfo.setModelType(tableVO.getModelType());
        tableInfo.setParentTable(parentTable);
        tableInfoDao.save(tableInfo);

        for (ColumnVO columnVO : dataList) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setName(columnVO.getFieldName());
            columnInfo.setType(columnVO.getFieldType());
            columnInfo.setLength(columnVO.getFieldLength());
            columnInfo.setCnName(columnVO.getFieldDescription());
            columnInfo.setDbName(tableInfo.getCnName());
            columnInfo.setDbId(tableInfo.getId());
            columnInfoDao.save(columnInfo);
        }
        //关闭会话
        session.close();
        return tableVO;
    }

    /**
     * @param map
     * @return int
     * @Author WWW
     * @Description 根据表名新增数据
     * @Date 16:17 2021/3/5
     **/
    @Override
    public int putValueByEntityName(Map<String, Object> map) {
        for (String tableName :
                map.keySet()) {
            //查找对应的表
            Specification spec = (Specification) (root, criteriaQuery, criteriaBuilder) -> {
                Predicate equal = null;
                Path name = root.get("Name");
                equal = criteriaBuilder.equal(name, tableName);
                return equal;
            };
            Optional one = tableInfoDao.findOne(spec);
            TableInfo tableInfo = null;
            if (one.isPresent()) {
                tableInfo = (TableInfo) one.get();
            }

            Object values = map.get(tableName);
            if (values instanceof Map) {
                //插入数据
                insertValue(tableInfo.getName(), tableInfo.getXml(), (Map) values);
            } else {
                //循环插入数据
                List valuesList = (List) values;
                for (int i = 0; i < valuesList.size(); i++) {
                    insertValue(tableInfo.getName(), tableInfo.getXml(), (Map) valuesList.get(i));
                }
            }
        }
        return 0;
    }

    /**
     * @param tableName
     * @param xml
     * @param map
     * @return void
     * @Author WWW
     * @Description 新增参数的方法
     * @Date 16:17 2021/3/5
     **/
    public void insertValue(String tableName, String xml, Map map) {
        CreateTableUtil creatTableUtil = new CreateTableUtil();
        Session newSession = creatTableUtil.getSession(entityManagerFactory, xml);
        SessionImpl session = (SessionImpl) newSession;
        EntityPersister entityPersister = session.getEntityPersister(tableName, map);
        Type[] propertyTypes = entityPersister.getPropertyTypes();
        String[] propertyNames = entityPersister.getEntityPersister().getPropertyNames();
        Object[] propertyValuesToInsert = entityPersister.getPropertyValuesToInsert(map, null, session);
        for (int i = 0; i < propertyValuesToInsert.length; i++) {
            Object value = propertyValuesToInsert[i];
            Type propertyType = propertyTypes[i];
            //先将Type转为java类
            if (propertyType instanceof TimestampType) {
                try {
                    Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String) value);
                    map.put(propertyNames[i], parse);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (propertyType instanceof IntegerType) {
                //然后调用强转方法
                int i1 = Integer.parseInt(propertyNames[i]);
                map.put(propertyNames[i], i1);

            }
            if (propertyType instanceof StringType) {
                //然后调用强转方法
                propertyNames[i] = propertyNames[i];
                map.put(propertyNames[i], propertyNames[i]);
            }
        }
        newSession.saveOrUpdate(tableName, map);
        newSession.close();
    }

    /**
     * 扫描表
     *
     * @param classList
     */
    @Override
    public void swaggerScan(List<Class<?>> classList) {
        for (Class<?> aClass : classList) {
            //不扫描自己
            if (!aClass.isAnnotationPresent(WorkFlowCoreNoScan.class)) {
                if (aClass.isAnnotationPresent(Entity.class)) {
                    TableInfo tableInfo = new TableInfo();
                    TableVO tableVO = new TableVO();
                    String className = getClassName(aClass.toString());
                    //入表真实名称
                    String realName = className.toLowerCase();
                    tableVO.setModelName(realName);
                    //获得类中文描述
                    if (aClass.isAnnotationPresent(ApiModel.class)) {
                        ApiModel annotation = aClass.getAnnotation(ApiModel.class);
                        StringBuilder apiModelDocument = new StringBuilder();
                        if (annotation.value() != null && !"".equals(annotation.value())) {
                            apiModelDocument.append(annotation.value() + "|");
                        }

                        if (annotation.description() != null && !"".equals(annotation.description())) {
                            apiModelDocument.append(annotation.description() + "|");
                        }

                        tableVO.setModelTitle(apiModelDocument.toString());
                    } else {
                        tableVO.setModelTitle("");
                    }
                    //获得类所有属性
                    Field[] declaredFields = aClass.getDeclaredFields();
                    java.lang.reflect.Type genericType = null;
                    List<ColumnVO> list = new ArrayList<>();
                    for (Field declaredField : declaredFields) {
                        ColumnVO columnVO = new ColumnVO();
                        //获得类型
                        genericType = declaredField.getGenericType();
                        //是否主键
                        if (declaredField.isAnnotationPresent(javax.persistence.Id.class)) {
                            columnVO.setPrimaryKey(0);
                        }
                        columnVO.setFieldType(getTypeName(genericType.toString()));

                        columnVO.setFieldName(getClassName(declaredField.toString()));
                        //获得属性中文描述
                        if (declaredField.isAnnotationPresent(ApiModelProperty.class)) {
                            ApiModelProperty annotation = declaredField.getAnnotation(ApiModelProperty.class);
                            StringBuilder apiModelPropertyDocument = new StringBuilder();
                            if (annotation.value() != null && !"".equals(annotation.value())) {
                                apiModelPropertyDocument.append(annotation.value() + "|");
                            }
                            if (annotation.example() != null && !"".equals(annotation.example())) {

                                apiModelPropertyDocument.append(annotation.example() + "|");
                            }
                            columnVO.setFieldDescription(apiModelPropertyDocument.toString());
                        } else {
                            columnVO.setFieldDescription("无描述");
                        }
                        list.add(columnVO);
                    }
                    tableVO.setDataList(list);
                    String xml = createTable(tableVO);
                    tableInfo.setName(tableVO.getModelName());
                    tableInfo.setCnName(tableVO.getModelTitle());
                    tableInfo.setXml(xml);
                    tableInfo.setModelType(0);
                    //判断是否存在
                    if (checkRepeat(realName)) {
                        tableInfo = tableInfoDao.save(tableInfo);
                        List<ColumnVO> dataList = tableVO.getDataList();
                        for (ColumnVO columnVO : dataList) {
                            ColumnInfo columnInfo = new ColumnInfo();
                            columnInfo.setName(columnVO.getFieldName());
                            columnInfo.setType(columnVO.getFieldType());
                            columnInfo.setLength(columnVO.getFieldLength());
                            columnInfo.setCnName(columnVO.getFieldDescription());
                            columnInfo.setPrimaryKey(columnVO.getPrimaryKey());
                            //暂定 简单类型
//                            if ("class java.lang.String".equals(genericType.toString())){
//                                columnInfo.setLength(255);
//                            } else if ("class java.lang.Integer".equals(genericType.toString())) {
//                                columnInfo.setLength(11);
//
//                            } else if ("class java.lang.Double".equals(genericType.toString())) {
//                                columnInfo.setLength(10);
//                            }
//                            else {
//                                columnInfo.setLength(0);
//                            }
                            setLength(columnInfo, genericType);
                            columnInfo.setDbName(className);
                            columnInfo.setDbId(tableInfo.getId());
                            columnInfoDao.save(columnInfo);

                        }
                    } else {
                        log.info("{}已存在", className);
                    }
                }
            }
        }
    }

    /**
     * @param tableName
     * @return boolean
     * @Author WWW
     * @Description 判重
     * @Date 10:50 2021/3/11
     **/
    public boolean checkRepeat(String tableName) {
        Specification spec = (Specification) (root, criteriaQuery, criteriaBuilder) -> {
            Path name = root.get("name");
            Predicate equal = criteriaBuilder.equal(name, tableName);
            return equal;
        };
        List<TableInfo> all = tableInfoDao.findAll(spec);

        for (TableInfo tableInfo : all) {
            String name = tableInfo.getName();
            if (tableName.equals(name)) {
                return false;
            }
        }
        return true;
    }

    /**
     * @param name
     * @return java.util.List
     * @Author WWW
     * @Description 通过表名查询所有信息
     * @Date 10:51 2021/3/11
     **/
    @Override
    public List findAllByName(String name) {
        if (name != null && name != "") {
            try {
                return Db.use().findAll(name);
            } catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public List complexQuery(String tableName, List<QueryCondition> queryConditions) {
        List<cn.hutool.db.Entity> list = null;
        if (!"".equals(tableName)) {
            String query = createQuery(tableName, queryConditions);
            try {
                list = Db.use().query(query);
            } catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        } else {
            return null;
        }
        return list;
    }

    @Override
    public List<TableInfo> listAllEntities() {
        return tableInfoDao.findAll();
    }
}
