package com.tykj.workflowcore.model_layer.utils;


import com.tykj.workflowcore.model_layer.entity.vo.ColumnVO;
import com.tykj.workflowcore.model_layer.entity.vo.TableVO;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

import javax.persistence.EntityManagerFactory;
import java.io.ByteArrayInputStream;
import java.util.EnumSet;
import java.util.List;

/**
 * @ClassName CreateTableUtil
 * @Description TODO
 * @Author WWW
 * @Date 2021/3/1 14:35
 * @Version 1.0
 */
public class CreateTableUtil {
    public static String createTable(TableVO tableVO){
        List<ColumnVO> dataList = tableVO.getDataList();
        String xmlMapping = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + tableVO.getModelName() + "\" table=\"" + tableVO.getModelName() + "\">\n";

        xmlMapping += " <id name=\"id\" type=\"java.lang.Integer\" length=\"64\" unsaved-value=\"null\">\n" +
                "            <generator class=\"identity\" />\n" +
                "        </id>";
        for (ColumnVO columnVO : dataList) {
            xmlMapping +=
                    " <property type=\"" + columnVO.getFieldType() + "\" name=\"" + columnVO.getFieldName() +
                            "\" column=\"" + columnVO.getFieldName() + "\"/>\n";

        }
        xmlMapping += "   </class>" +
                "</hibernate-mapping>";

        return xmlMapping;
    }


    public Session getSession(EntityManagerFactory entityManagerFactory,String xml){

        SessionFactory sessionFactory = entityManagerFactory.unwrap(SessionFactory.class);
        StandardServiceRegistry serviceRegistry = sessionFactory.getSessionFactoryOptions().getServiceRegistry();
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        sessionFactory.getSessionFactoryOptions();
        metadataSources.addInputStream(new ByteArrayInputStream(xml.getBytes()));
        Metadata metadata = metadataSources.buildMetadata();
        //更新数据库Schema,如果不存在就创建表,存在就更新字段,不会影响已有数据
        SchemaUpdate schemaUpdate = new SchemaUpdate();
        schemaUpdate.execute(EnumSet.of(TargetType.DATABASE), metadata, serviceRegistry);

        metadata = metadataSources.buildMetadata();
        //创建会话工厂
        SessionFactory newSessionFactory = metadata.buildSessionFactory();
        //保存对象
        Session newSession = newSessionFactory.openSession();

        return newSession;
    }



    public  static  String getClassName(String aClass){
        int i = aClass.lastIndexOf(".");
        String substring = aClass.substring(i+1);
        return substring;
    }

    public  static  String getTypeName(String aClass){

        return aClass.replace("class ", "");
    }
}
