package com.tykj.workflowcore.api.controller;

import com.tykj.workflowcore.api.entity.ClassInfo;
import com.tykj.workflowcore.api.entity.InvokeRequest;
import com.tykj.workflowcore.api.service.ApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "函数管理接口")
@RestController("/api/info")
public class ApiController {

    private final ApiService apiService;

    public ApiController(ApiService apiService) {
        this.apiService = apiService;
    }

    @ApiOperation(value =  "查询所有可调用函数信息")
    @GetMapping
    public ResponseEntity<List<ClassInfo>> findAll() {
        return ResponseEntity.ok(apiService.findAll());
    }

    @ApiOperation(value = "调用指定函数")
    @PostMapping
    public void invoke(@RequestBody InvokeRequest invokeRequest) {
        apiService.invoke(invokeRequest.getClassName(),invokeRequest.getName(),invokeRequest.getParams());
    }

}
