package com.tykj.workflowcore.workflow_editer.entity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * ClassName:    NodePage
 * Package:    com.tykj.entity
 * Description:
 * Datetime:    2021/3/3   13:08
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@Api("节点所在页面")
public class NodePage {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("节点id")
    private String nodeId;

    @ApiModelProperty("页面id")
    private long pageId;

    private String flowKey;

    private String flowName;

}
