package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.entity.PageEntity;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
import com.tykj.workflowcore.workflow_editer.service.PageEntityService;
import com.tykj.workflowcore.workflow_editer.vo.InFormPageVo;
import com.tykj.workflowcore.workflow_editer.vo.OutFormPageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * ClassName:    FormPageController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/3   13:40
 *
 * @Author: zsp
 */
@RestController("/formPage")
@RequestMapping
@Api("页面管理接口")
public class FormPageController {

    @Autowired
    private FormPageService formPageService;
    @Autowired
    private PageEntityService pageEntityService;

    @ApiOperation("保存页面")
    @PostMapping("/savePage")
    public Long savePage(@RequestBody InFormPageVo inFormPageVo){
        List<String> entityIds = inFormPageVo.getEntityIds();
        for (String entityId : entityIds) {
            PageEntity pageEntity = new PageEntity();
            pageEntity.setEntityId(entityId);
            pageEntity.setPageId(formPageService.savePage(inFormPageVo));
            pageEntityService.savePageEntity(pageEntity);
        }
        return  formPageService.savePage(inFormPageVo);

    }

    @ApiOperation("回显页面")
    @GetMapping("/EchoPage/{id}")
    public FormPage EchoPage(@PathVariable("id") Long id){
        return  formPageService.getPage(id);
    }

    @ApiOperation("查看页面")
    @GetMapping("/findPages")
    public List<OutFormPageVo> findPages(){
        return  formPageService.getAllPages();
    }

    @ApiOperation("删除页面")
    @DeleteMapping("deletePage/{id}")
    public void deletePage(@PathVariable("id") Long id){
        formPageService.deletePage(id);
    }

}
