package com.tykj.workflowcore.workflow_editer.controller;

import com.tykj.workflowcore.model_layer.model.TableInfo;
import com.tykj.workflowcore.workflow_editer.entity.PageEntity;
import com.tykj.workflowcore.workflow_editer.service.PageEntityService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * ClassName:    PageEntityController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/3/4   9:50
 *
 * @Author: zsp
 */
@RestController
@RequestMapping("/pageEntity")
@Api("页面跟实体的管理")

public class PageEntityController {

    @Autowired
    private PageEntityService pageEntityService;

    @PostMapping("/savePageEntity")
    public void savePageEntity(@RequestBody PageEntity pageEntity){
        pageEntityService.savePageEntity(pageEntity);
    }

    @PostMapping("/findByPages")
    public List<TableInfo> findByPages(List<Integer> pageIds){

        return pageEntityService.findByPageIds(pageIds);
    }
}
