package com.tykj.workflowcore.base.util;

import java.io.*;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class FileUtil
 * @packageName com.tykj.workflowcore.base.util
 **/
public class FileUtil {
    public static File createFileByString(String filePath,String fileString){
        File f = null;
        try {
            f = new File(filePath);
            // 判断文件是否存在
            if(!f.exists()){
                f.createNewFile();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new StringReader(fileString));
            bufferedWriter = new BufferedWriter(new FileWriter(f));
            //字符缓冲区
            char buf[] = new char[1024];
            int len;
            while ((len = bufferedReader.read(buf)) != -1) {
                bufferedWriter.write(buf, 0, len);
            }
            bufferedWriter.flush();
            bufferedReader.close();
            bufferedWriter.close();
        } catch (IOException e) {
            e.printStackTrace();

        } finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return f;
    }
}
