package com.tykj.workflowcore.model_layer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;

/**
 * @ClassName AggregationRelationship
 * @Description TODO
 * @Author WWW
 * @Date 2021/4/2 9:49
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Data
@NoArgsConstructor
@Entity
@SQLDelete(sql = "update column_info set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
public class AggregationRelationship extends BaseEntity {

    @ApiModelProperty("聚合对象ID")
    private Integer tableInfoExId;

    @ApiModelProperty("附表id")
    private Integer sideTableId;

    @ApiModelProperty("聚合对象关系")
    private Integer relationship;

    @ApiModelProperty("主表连接属性")
    private String mainTableConnectionKey;

    @ApiModelProperty("副表连接属性")
    private String sideTableConnectionKey;

    @ApiModelProperty("中间表名称")
    private String connectionTableName;
}
