package com.tykj.workflowcore.api.controller;

import com.tykj.workflowcore.api.entity.ApiInfo;
import com.tykj.workflowcore.api.entity.InvokeRequest;
import com.tykj.workflowcore.api.service.ApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "函数管理接口")
@RestController()
@RequestMapping("/api/info")
public class ApiController {

    private final ApiService apiService;

    public ApiController(ApiService apiService) {
        this.apiService = apiService;
    }

    @ApiOperation(value = "查询所有可调用函数信息")
    @GetMapping
    public ResponseEntity<List<ApiInfo>> findAll() {
        return ResponseEntity.ok(apiService.findAll());
    }

    @ApiOperation(value = "调用指定函数")
    @PostMapping
    public void invoke(@RequestBody InvokeRequest invokeRequest) {
        apiService.invoke(invokeRequest.getClassName(), invokeRequest.getName(), invokeRequest.getParams());
    }


}
