package com.tykj.workflowcore.model_layer.service;


import com.tykj.workflowcore.model_layer.entity.ColumnInfo;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.entity.vo.*;

import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelService
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:36
 * @Version 1.0
 */
@Service
public interface ModelService {

    /**
     * 分页查询
     * @param searchTableInfoVo
     * @return
     * @throws SQLException
     */
//    @Cacheable(cacheNames = "tableInfos",sync = true)
    Page<TableInfo> listAllEntities(SearchTableInfoVo searchTableInfoVo) throws SQLException;


    /**
     * 方法重载不分页查询
     * @return
     * @throws SQLException
     */
    List<TableInfo> listAllEntities() throws SQLException;



    /**
     * 根据表名查询所有字段信息
     * @param searchColumnInfoVo
     * @return
     */
//    @Cacheable(cacheNames = "tableInfos")
    List<ColumnInfo> showModelFields(SearchColumnInfoVo searchColumnInfoVo);



    /**
     * 新建模型
     * @param tableVO
     * @return
     */
//    @CachePut(cacheNames = "tableInfos")
//    @CacheEvict(cacheNames = "tableInfos",allEntries = true)
    TableInfo newTable(TableVO tableVO);

    /**
     * 根据表名插入数据
     * @param map
     * @return
     */
    int putValueByEntityName(Map<String, Object> map);

    /**
     * 扫描
     * @param classList
     */
    void swaggerScan(List<Class<?>> classList);

    /**
     * 根据表名查询所有
     * @param name
     * @return
     * @throws SQLException
     */
    List<Map<String, Object>>  findAllByName(String name) throws SQLException;


    /**
     * 复杂查询
     * @param tableName
     * @param queryConditions
     * @return
     */
    List<Map<String, Object>> complexQuery(String tableName, List<QueryCondition> queryConditions);


    /**
     * 修改表
      * @param updateTableInfoVO
     * @return
     */
//    @CachePut(cacheNames = "tableInfos")
//    @CacheEvict(cacheNames = "tableInfos",allEntries = true)

    int updateTable(UpdateTableInfoVO updateTableInfoVO);


    /**
     * 删除表
     * @param delTableVO
     * @return
     */
//    @CacheEvict(cacheNames = "tableInfos",allEntries = true)
    int delTable(DelTableVO delTableVO);


    /**
     * 根据id批量查询所有tableInfo和ColumnInfo
     * @param ids
     * @return
     */
    TableAndColumnInfoVO getTableInfoAndColumnInfoByBatch(Integer[] ids);


}
