package com.tykj.workflowcore.model_layer.controller;


import com.tykj.workflowcore.base.result.ResultUtil;

import com.tykj.workflowcore.model_layer.entity.vo.*;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.service.ModelService;
import com.tykj.workflowcore.model_layer.service.impl.ModelHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.sql.SQLException;

import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelController
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:35
 * @Version 1.0
 */
@Slf4j
@RestController
@RequestMapping("/model")
@Api(tags = "数据模型层接口")
public class ModelController {

    @Autowired
    private ModelService modelService;

    @Autowired
    private ModelHelper modelHelper;

    /**
     * @param
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.TableInfo>
     * @Author WWW
     * @Description 得到所有数据库信息
     * @Date 16:19 2021/3/4
     **/
    @ApiOperation("得到所有数据表信息")
    @PostMapping("/getAllEntity")
    public ResponseEntity getAllEntity(@RequestBody SearchTableInfoVo searchTableInfoVo) {
        Page<TableInfo> tableInfos;
        tableInfos = modelService.pageAllEntities(searchTableInfoVo);
        return ResultUtil.success(tableInfos, "数据查询成功！");
    }

    /**
     * @param searchColumnInfoVo
     * @return java.util.List<com.tykj.workflowcore.model_layer.model.ColumnInfo>
     * @Author WWW
     * @Description 根据表名得到所有字段名
     * @Date 16:20 2021/3/4
     **/
    @ApiOperation("根据表名或者id查询表中所有字段")
    @PostMapping("/getAllField")
    public ResponseEntity getFields(@RequestBody SearchColumnInfoVo searchColumnInfoVo) {
        return ResultUtil.success(modelService.showModelFields(searchColumnInfoVo), "数据查询成功！");
    }

    /**
     * @param
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 新增数据模型
     * @Date 16:21 2021/3/4
     **/
    @ApiOperation("新增数据模型")
    @PostMapping(value = "/addModel")
    public ResponseEntity addModel(@RequestBody TableVO tableVO) throws Exception {
        SearchTableInfoVo searchTableInfoVo = new SearchTableInfoVo();
        searchTableInfoVo.setModelName(tableVO.getModelName());
        List<TableInfo> tableInfos = modelService.listAllEntities(searchTableInfoVo);
        if (tableInfos.size()>0){
            return ResultUtil.failed("表已经存在！");
        }

        long start = System.currentTimeMillis();
        modelService.newTable(tableVO);
        long end = System.currentTimeMillis();

        log.warn("创建总用时为：{}秒", (end - start) / 1000.0);
        return ResultUtil.success("", "新建成功!");

    }

    /**
     * @param map
     * @return int
     * @Author WWW
     * @Description 对应表插入数据
     * map （表名，字段数据）
     * @Date 16:22 2021/3/4
     **/
    @ApiOperation(value = "根据表名表插入数据")
    @PostMapping("/insertValues")
    public ResponseEntity insertValues(@RequestBody Map<String, Object> map) {
        int i = modelService.putValueByEntityName(map);
        if (i == 0) {
            return ResultUtil.success("", "数据插入成功！");
        }
        return ResultUtil.failed("模型类型不支持插入数据！");

    }

    /**
     * @param tableName
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 根据表名查询所有数据
     * @Date 9:30 2021/3/11
     **/
    @ApiOperation("根据表名查询所有数据")
    @GetMapping("/getAll")
    public ResponseEntity getAll(String tableName) {
        try {
            return ResultUtil.success(modelService.findAllByName(tableName), "查询成功！");
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return ResultUtil.success(null, "获取失败!");
    }

    /**
     * @param tableName
     * @param queryConditions
     * @return org.springframework.http.ResponseEntity
     * @Author WWW
     * @Description 复杂查询
     * @Date 11:03 2021/3/11
     **/
    @ApiOperation("复杂查询")
    @GetMapping("/complexQuery")
    public ResponseEntity complexQuery(@RequestParam(value = "tableName")String tableName,
                                       @RequestParam(value = "queryConditions" ,required=false) List<QueryCondition> queryConditions) {
        List list = modelService.complexQuery(tableName, queryConditions);
        if (list != null) {
            return ResultUtil.success(list, "查询成功!");
        }
        return ResultUtil.success(null, "没有数据!");
    }

    @ApiOperation("编辑操作")
    @PutMapping("/update")
    public ResponseEntity updateTable(@RequestBody UpdateTableInfoVO updateTableInfoVO) {
        long start = System.currentTimeMillis();
        int i = modelService.updateTable(updateTableInfoVO);
        if (i == 1) {
            long end = System.currentTimeMillis();
            log.warn("创建总用时为：{}秒", (end - start) / 1000.0);
            return ResultUtil.success("", "修改成功！");
        }
        return ResultUtil.success("业务类型不支持修改！");
    }

    @ApiOperation("删除操作")
    @DeleteMapping("/delete")
    public ResponseEntity delTable(DelTableVO delTableVO) {

        int i = modelService.delTable(delTableVO);
        if (i == 1) {
            return ResultUtil.success("", "删除成功！");
        }
        return ResultUtil.success("业务类型不支持删除！");
    }


    @ApiOperation("获得获得非聚合对象example")
    @GetMapping("/example")
    public ResponseEntity getjsonExample(Integer id) {
        return ResultUtil.success(modelHelper.getJsonExpample(id),
                "获得非聚合对象example成功！");
    }

    @ApiOperation("获得聚合对象example")
    @GetMapping("/exExample")
    public ResponseEntity getjsonExExample(Integer id) {
        return ResultUtil.success(modelHelper.getExJsonExample(id),
                "获得聚合对象example成功！");
    }
}
