package com.tykj.workflowcore.model_layer.utils;

import com.tykj.workflowcore.base.result.ApiException;
import com.tykj.workflowcore.model_layer.myEnum.AggregationType;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.util.StringUtils;


/**
 * @ClassName AggregationUtil
 * @Description TODO 生成聚合对象xml
 * @Author WWW
 * @Date 2021/4/1 18:59
 * @Version 1.0
 */
public class AggregationUtil {
    //xml工具

    public static Document getDocument(String xml){
        try {
            return DocumentHelper.parseText(xml);
        } catch (DocumentException e) {
            throw new ApiException("XML格式不正确");
        }
    }

    public static Document changeClassName(String className,Document document){
        Element aClass = getNode(document);
        aClass.attribute("entity-name").setValue(className);
        return aClass.getDocument();
    }

    public static Element createOneToOneElement(String name,String connectionKey,String sideTableName ) {
        Element element = DocumentHelper.createElement("one-to-one");
        element.addAttribute("name", name);
        element.addAttribute("property-ref", connectionKey);
        element.addAttribute("class", sideTableName);
        element.addAttribute("cascade", "save-update");
        return element;
    }

    public static Element createOneToManyElement(String name,
                                                 String sideTableName,
                                                 String sideTableConnectionKey) {
        //创建ELEMETN
        Element setElement = createSetElement(
                name,
                sideTableName,
                "",
                "",
                sideTableConnectionKey,
                AggregationType.ONE_TO_MANY);
        return setElement;
    }



    public static Element createManyToManyElement(String sideTableName,String uuidTableName,String connectionTableName,String mainTableConnectionKey, String sideTableConnectionKey) {
        Element setElement = createSetElement(sideTableName,
                StringUtils.isEmpty(uuidTableName)?sideTableName:uuidTableName,
                connectionTableName,
                mainTableConnectionKey,
                sideTableConnectionKey,
                AggregationType.MANY_TO_MANY);
        return setElement;
    }

    public static Element getNode(Document document) {
        return document.getRootElement().element("class");
    }

    public static Element createSetElement(String name,
                                           String sideTableName,
                                           String connectionTableName,
                                           String mainTableConnectionKey,
                                           String sideTableConnectionKey,
                                           Integer type){
        //创建element
        Element elementSet = DocumentHelper.createElement("set");
        elementSet.addAttribute("name", name);
        elementSet.addAttribute("cascade", "save-update");
        Element elementKey = DocumentHelper.createElement("key");
        if (type.equals(AggregationType.MANY_TO_MANY)){
            elementSet.addAttribute("table", connectionTableName);
            elementKey.addAttribute("column",mainTableConnectionKey);
            elementSet.add(elementKey);
            Element elementManyToMany = DocumentHelper.createElement("many-to-many");
            elementManyToMany.addAttribute("class",sideTableName);
            elementManyToMany.addAttribute("column",sideTableConnectionKey);
            elementSet.add(elementManyToMany);
        }else if (type.equals(AggregationType.ONE_TO_MANY)){
            elementKey.addAttribute("column",sideTableConnectionKey);
            elementSet.add(elementKey);
            Element elementOneToMany = DocumentHelper.createElement("one-to-many");
            elementOneToMany.addAttribute("class",sideTableName);
            elementSet.add(elementOneToMany);
        }

        return elementSet;
    }




}
