package com.tykj.workflowcore.base.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class BaseEntity
 * @packageName com.example.demo.entity
 **/

@Data
@MappedSuperclass
public abstract class BaseEntity {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    protected Integer id;

    @ApiModelProperty("创建时间")
    @Temporal(TemporalType.TIMESTAMP)
    protected Date createdTime;

    @ApiModelProperty("修改时间")
    @Temporal(TemporalType.TIMESTAMP)
    protected Date updatedTime;

    @ApiModelProperty("逻辑删除 0为 false 1为 true")
    protected Integer deleted = 0;

}
