package com.tykj.workflowcore.model_layer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Lob;

/**
 * @ClassName TableInfoEX
 * @Description TODO 聚合对象
 * @Author WWW
 * @Date 2021/4/1 16:45
 * @Version 1.0
 */
@WorkFlowCoreNoScan
@Data
@NoArgsConstructor
@Entity
@SQLDelete(sql = "update column_info set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
public class TableInfoEx extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("主表id")
    private Integer mainTableId;

    @Lob
    @ApiModelProperty("聚合对象xml")
    private String xml;




}
