package com.tykj.workflowcore.workflow_editer.controller;

import com.alibaba.fastjson.JSON;
import com.tykj.workflowcore.base.result.ResultUtil;
import com.tykj.workflowcore.workflow_editer.entity.DataHistory;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.entity.vo.*;
import com.tykj.workflowcore.workflow_editer.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.xml.stream.XMLStreamException;
import java.io.IOException;
import java.util.Map;


/**
 * ClassName:    FlowsInfoController
 * Package:    com.tykj.controller
 * Description:
 * Datetime:    2021/2/24   10:13
 * @Author: zsp
 */
@RestController
@Api(tags = "历史数据接口")
@RequestMapping("/dataHistory")
public class DataHistoryController {

    @Autowired
    private FlowInfoService flowInfoService;

    @Autowired
    private WorkFlowService workFlowService;

    @Autowired
    private NodeInfoService nodeInfoService;

    @Autowired
    private VariableStorageService variableStorageService;

    @Autowired
    private DataHistoryService dataHistoryService;

    @PostMapping("/saveDataHistory")
    @ApiOperation(value = "保存历史数据")
    public void saveDataHistory(@RequestBody DataHistory dataHistory){
        dataHistoryService.saveData(dataHistory);
    }

    @GetMapping("/findByTaskId")
    @ApiOperation(value = "通过任务id查询数据")
    public Map<String,Object> findByTaskId(String taskId){

        DataHistory byTaskId = dataHistoryService.findByTaskId(taskId);
        String datas = byTaskId.getDatas();
        Map map = (Map) JSON.parse(datas);
        return map;
    }

}
