package com.tykj.workflowcore.workflow_editer.entity;

import com.tykj.workflowcore.base.entity.BaseEntity;
import com.tykj.workflowcore.model_layer.annotations.WorkFlowCoreNoScan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Lob;

/**
 * ClassName:    DataHistory
 * Package:    com.tykj.workflowcore.workflow_editer.entity
 * Description:
 * Datetime:    2021/4/16   15:21
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@WorkFlowCoreNoScan
@SQLDelete(sql = "update flows_info set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
@Api("历史数据展示页面")
public class DataHistory extends BaseEntity {

    @ApiModelProperty("任务id")
    private String taskId;

    @ApiModelProperty("节点id")
    private String nodeId;

    @ApiModelProperty("变量数据")
    @Lob
    private String datas;

    @ApiModelProperty("流程实例id")
    private String processInstanceId;

    @ApiModelProperty("流程主键id")
    private String flowKey;


}
