package com.tykj.workflowcore.workflow_editer.service;

import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;

import com.tykj.workflowcore.workflow_editer.entity.vo.SearchVariableStorageVo;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * ClassName:    VariableStorageService
 * Package:    com.tykj.service
 * Description:
 * Datetime:    2021/3/3   10:10
 *
 * @Author: zsp
 */
public interface VariableStorageService {

    /**
     * 保存接口调用配置
     * @param variableStorage 变量池
     */
    VariableStorage saveVariableStorageService(@RequestBody VariableStorage variableStorage);

    /**
     * 根据流程主键查询
     * @param searchVariableStorageVo 流程主键
     * @return VariableStorage 变量池
     */
    List<VariableStorage> searchVariableStorageList(SearchVariableStorageVo searchVariableStorageVo);

    /**
     * 多条件查询接口配置
     * @param searchVariableStorageVo
     * @return
     */
    Page<VariableStorage> searchVariableStoragePage(SearchVariableStorageVo searchVariableStorageVo);
}
