package com.tykj.workflowcore;

import com.tykj.workflowcore.model_layer.controller.ModelController;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import org.aspectj.lang.annotation.Before;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;


import java.util.Optional;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.*;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@AutoConfigureMockMvc
class WorkflowCoreApplicationTests {

    @Autowired
    ModelController modelController;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    TableInfoDao tableInfoDao;

    @Autowired
    MockMvc mockMvc;

    @Before("")
    public void setUp() {
        mockMvc = MockMvcBuilders.standaloneSetup(modelController).build();
    }

    @Test
    void contextLoads() {
        System.out.println("11111111111111111111111");

    }
//#####################################模型层测试 start##############################################

    RequestBuilder request;

    @Test
    public void SearchTableVOTest() throws Exception {

        String SearchTableinfo_Json = "{\n" +
                "    \"modelName\":\"peop\",\n" +
                "    \"modelTitle\":\"\",\n" +
                "    \"modelType\":\"\"\n" +
                "}";
        request = post("/model/getAllEntity/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(SearchTableinfo_Json)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }

    @Test
    public void testSearchColumnVO() throws Exception {

        String searchColumnV0_json = "{\n" +
                "\"dbId\":2\n" +
                "}";

        String searchColumnV0_json2 = "{\n" +
                "\"dbName\":\"techer\"\n" +
                "}";
        request = post("/model/getAllField/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(searchColumnV0_json2)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

    @Test
    public void addModelTest() throws Exception {

        String TableVo_json = "{\n" +
                "\"modelName\":\"people2\",\n" +
                "\"modelTitle\":\"人2\",\n" +
                "\"modelType\":1,\n" +
                "\"parentTable\":\"\",\n" +
                "\"description\":\"详细信息\",\n" +
                "\"dataList\":[\n" +
                "    {\"fieldName\": \"c1\", \"fieldTitle\": \"列1\", \"fieldType\": \"java.lang.String\", \"fieldLength\": \"255\"},\n" +
                "    {\"fieldName\": \"c2\", \"fieldTitle\": \"列2\", \"fieldType\": \"java.lang.String\", \"fieldLength\": \"255\"}\n" +
                "]\n" +
                "}";
        request = post("/model/addModel/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(TableVo_json)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andExpect(content().string(not("[]")))
                .andExpect(content().string(equalTo("{\"message\":\"新建成功\",\"data\":\"\"}")))
                .andDo(print());//打印输出结果
    }

    @Test
    public  void  inserValuesByTableName() throws Exception {
        String values_json="{\"techer\":{\"name\": \"zhangsan\",\"age\" :\"20\"}}";

        request = post("/model/insertValues/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(values_json)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andExpect(content().string(not("[]")))
                .andExpect(content().string(equalTo("{\"message\":\"数据插入成功\",\"data\":\"\"}")))
                .andDo(print());//打印输出结果
    }

    @Test
    public void findAllbyTableName() throws Exception {
        request=get("/model/getAll/")
                .param("tableName","techer")
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request)
                .andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andDo(print());

    }


    @Test
    public void testDelTable(){
//        jdbcTemplate.execute("drop table if exists test"); ok
        Optional<TableInfo> byId = tableInfoDao.findById(12);
       if (byId.isPresent()){
           TableInfo tableInfo = byId.get();
           System.out.println(tableInfo);
           tableInfoDao.delete(tableInfo);
       }

    }
}
