package com.tykj.workflowcore.workflow_editer.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.workflowcore.workflow_editer.entity.FlowsInfo;
import com.tykj.workflowcore.workflow_editer.entity.NodeInfo;
import com.tykj.workflowcore.workflow_editer.entity.vo.NodeInfoVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import java.util.Date;
import java.util.List;

/**
 * ClassName:    FlowInfoVo
 * Package:    com.tykj.vo
 * Description:
 * Datetime:    2021/3/1   9:54
 *
 * @Author: zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FlowsInfoVo {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("发起人的名字")
    private Integer userName;

    @ApiModelProperty("流程名称")
    private String flowName;

    @ApiModelProperty("流程主键")
    private String flowKey;

    @ApiModelProperty(value = "部署状态",notes = "0 已部署，1 未部署")
    private Integer state = 1;

    @ApiModelProperty("流程创建时间")
    private Date createTime;

    @ApiModelProperty("流程修改时间")
    private Date updateTime;

    @ApiModelProperty("流程描述")
    private String flowDescribe;

    @ApiModelProperty
    private String fileXml;

    @ApiModelProperty("开始节点的id")
    private String startId;

    @ApiModelProperty("开始节点的id")
    private String startPageId;

    @ApiModelProperty("是否和之前一样  0是一样  1不一样")
    private Integer isOld = 1;
    @ApiModelProperty()
    private List<NodeInfo> nodeInfoList;

    public FlowsInfo toEntity(){
        FlowsInfo flowsInfo = new FlowsInfo();
        BeanUtils.copyProperties(this,flowsInfo);
        return flowsInfo;
    }
}
