package com.tykj.workflowcore.workflow_editer.entity.vo;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonParser;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;
import springfox.documentation.spring.web.json.Json;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class VariableStorageVo
 * @packageName com.tykj.workflowcore.workflow_editer.entity.vo
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class VariableStorageVo {

    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("流程主键")
    private String flowKey;

    @ApiModelProperty("节点Id")
    private String activityId;

    @ApiModelProperty("调用类名")
    private String className;

    @ApiModelProperty("调用方法名")
    private String method;

    private InvokeRequestVo invokeRequest;

    public VariableStorage toEntity(){
        VariableStorage variableStorage = new VariableStorage();
        BeanUtils.copyProperties(this,variableStorage);
        variableStorage.setInvokeRequest(JSON.toJSONString(invokeRequest));
        return variableStorage;
    }
}
