package com.tykj.workflowcore.workflow_editer.listener;

import com.alibaba.fastjson.JSONObject;
import com.tykj.workflowcore.api.controller.ApiController;
import com.tykj.workflowcore.api.entity.InvokeRequest;
import com.tykj.workflowcore.api.entity.Parameter;
import com.tykj.workflowcore.workflow_editer.entity.CommandGetValue;
import com.tykj.workflowcore.workflow_editer.entity.VariableStorage;
import com.tykj.workflowcore.workflow_editer.entity.vo.InvokeRequestVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.SearchVariableStorageVo;
import com.tykj.workflowcore.workflow_editer.service.VariableStorageService;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.*;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.engine.delegate.event.FlowableActivityEvent;
import org.flowable.engine.delegate.event.impl.FlowableActivityEventImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ProcessEndListener
 * @packageName com.tykj.workflowcore.workflow_editer.listener
 **/
@Component
public class ProcessEndListener extends AbstractFlowableEngineEventListener {

    @Autowired
    RuntimeService runtimeService;

    @Autowired
    RepositoryService repositoryService;

    @Autowired
    VariableStorageService variableStorageService;

    @Autowired
    ProcessEngineConfigurationImpl processEngineConfiguration;

    @Autowired
    ApiController apiController;



    @Override
    protected void processCompleted(FlowableEngineEntityEvent event) {
        //流程结束了
//        if (event.getEntity() instanceof ProcessInstance){
//            ProcessInstance processInstance = (ProcessInstance) event.getEntity();
//            String processDefinitionId = processInstance.getProcessDefinitionId();
//            String flowKey = processDefinitionId;
//            if (processDefinitionId.indexOf(":")>=0){
//                flowKey = processDefinitionId.substring(0,processDefinitionId.indexOf(":"));
//            }
//            List<VariableStorage> variableStorageList = variableStorageService.searchVariableStorageList(new SearchVariableStorageVo(flowKey));
//            for (VariableStorage variableStorage : variableStorageList) {
//                InvokeRequestVo variableInfo = variableStorage.getInvokeRequest();
//                variableInfo.setProcessInstance(processInstance);
//                //调用服务接口
//
//                //1. 获取调用的具体数值
//                apiController.invoke(getApiInvokeParam(variableInfo));
//            }
//        }
//        throw new ApiException("强行报错");
    }

    @Override
    protected void taskCompleted(FlowableEngineEntityEvent event) {
        super.taskCompleted(event);
    }

    @Override
    public void onEvent(FlowableEvent flowableEvent) {
        super.onEvent(flowableEvent);
    }

    @Override
    protected void activityCompleted(FlowableActivityEvent event) {
        super.activityCompleted(event);
        if (event instanceof FlowableActivityEventImpl){
            DelegateExecution execution = ((FlowableActivityEventImpl) event).getExecution();
            if (execution.getCurrentFlowElement() instanceof EndEvent){
                System.out.println("流程结束了");
                String processDefinitionId = execution.getProcessDefinitionId();
                String flowKey = processDefinitionId;
                if (processDefinitionId.indexOf(":")>=0){
                    flowKey = processDefinitionId.substring(0,processDefinitionId.indexOf(":"));
                 }
                List<VariableStorage> variableStorageList = variableStorageService.searchVariableStorageList(new SearchVariableStorageVo(flowKey,execution.getCurrentActivityId()));
                for (VariableStorage variableStorage : variableStorageList) {
                    InvokeRequestVo variableInfo = variableStorage.getInvokeRequest();
                    variableInfo.setProcessInstance(execution);
                    //调用服务接口
                    apiController.invoke(getApiInvokeParam(variableInfo));
                }
            }
        }
    }

    /**
     * 获取调用Api用的参数
     *
     * @param invokeRequestVo 调用服务接口vo
     * @return 调用服务接口实体
     */
    public InvokeRequest getApiInvokeParam(InvokeRequestVo invokeRequestVo) {
        //拿出taskId
        DelegateExecution execution = invokeRequestVo.getProcessInstance();
        List<Parameter> parameterList = invokeRequestVo.getParams();
        List<Parameter> newParameterList = new ArrayList<>();
        for (int i = 0; i < parameterList.size(); i++) {
            Parameter parameter = parameterList.get(i);
            if (!StringUtils.isEmpty(parameter.getExp())) {
                //如果是表示式  如：${people}
                parameter.setInstance((Map<String, Object>) getProcessValue(execution, parameter.getExp()));
            } else {
                Map<String, Object> instance = parameter.getInstance();
                JSONObject newInstance = new JSONObject();
                //遍历param的key
                Set<String> oldInstanceKey = instance.keySet();
                for (String key : oldInstanceKey) {
                    newInstance.put(key, getProcessValue(execution, (String) instance.get(key)));
                }
                parameter.setInstance(newInstance);
            }
            newParameterList.add(i, parameter);
        }
        invokeRequestVo.setParams(newParameterList);
        return JSONObject.parseObject(JSONObject.toJSONString(invokeRequestVo), InvokeRequest.class);
    }

    public Object getProcessValue(DelegateExecution execution, String exp) {
        // processInstance -> ExecutionEntity
        Expression expression = processEngineConfiguration.getExpressionManager().createExpression(exp);
        return expression.getValue(execution);
    }

}
