package com.tykj.workflowcore.workflow_editer.service.impl;


import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.entity.TableInfo;
import com.tykj.workflowcore.model_layer.entity.vo.TableAndColumnInfoVO;
import com.tykj.workflowcore.model_layer.service.ModelService;
import com.tykj.workflowcore.workflow_editer.entity.FormPage;
import com.tykj.workflowcore.workflow_editer.dao.FormPageMapper;
import com.tykj.workflowcore.workflow_editer.service.FormPageService;
import com.tykj.workflowcore.workflow_editer.entity.vo.FormPageVo;
import com.tykj.workflowcore.workflow_editer.entity.vo.PageFormPageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * ClassName:    PageEntityServiceImpl
 * Package:    com.tykj.service.impl
 * Description:
 * Datetime:    2021/3/3   13:16
 *
 * @Author: zsp
 */
@Service
public class FormPageServiceImpl implements FormPageService {

    @Autowired
    private FormPageMapper formPageMapper;
    @Autowired
    private ModelService modelService;
    @Override
    public Integer savePage(@RequestBody FormPageVo inFormPageVo) {
        inFormPageVo.setCreateTime(new Date());
        FormPage formPage = inFormPageVo.toEntity();
        FormPage formPage1 = formPageMapper.save(formPage);
        Integer id = formPage1.getId();
        return id;
    }

    @Override
    public void update(FormPage formPage) {
        formPageMapper.save(formPage);
    }

    @Override
    public FormPageVo getPage(Integer id) {

        FormPage formPage = formPageMapper.findById(id).get();

        return   formPage.toEntityVo();
    }

    @Override
    public void deletePage(Integer id) {
        FormPage formPage = formPageMapper.findById(id).get();
        formPageMapper.delete(formPage);
    }

    @Override
    public Page<FormPage> getAllPages(PageFormPageVo pageFormPageVo) {

        PredicateBuilder<FormPage> and = Specifications.and();
        and.eq(pageFormPageVo.getPageName()!=null,"pageName",pageFormPageVo.getPageName());
        and.eq(pageFormPageVo.getPageDesc()!=null,"pageDesc",pageFormPageVo.getPageDesc());
        and.eq(pageFormPageVo.getCreateTime()!=null,"createTime",pageFormPageVo.getCreateTime());

        Page<FormPage> formPagePage = formPageMapper.findAll(and.build(), pageFormPageVo.getPageable());

        return formPagePage;
    }

    @Override
    public TableAndColumnInfoVO findByPageIds(List<Integer> pageIds) {
        ArrayList<TableInfo> list = new ArrayList<>();

        PredicateBuilder<FormPage> builder = Specifications.and();
        builder.in("id", pageIds);
        List<FormPage> tableInfoList = formPageMapper.findAll(builder.build());
        StringBuffer entityIds = new StringBuffer();
        for (FormPage formPage : tableInfoList) {
            String entityId = formPage.getEntityId();
            entityIds.append(entityId);
            entityIds.append(",");
        }
        String[] split = entityIds.toString().split(",");
        List<String> lastEntityIds = Arrays.asList(split).stream().distinct().collect(Collectors.toList());
        //todo
        Integer[] ids = (Integer[]) lastEntityIds.toArray();

        return  modelService.getTableInfoAndColumnInfoByBatch(ids);
    }

}
