package com.tykj.workflowcore.model_layer.utils;



import com.tykj.workflowcore.model_layer.entity.vo.ColumnVO;
import com.tykj.workflowcore.model_layer.entity.vo.TableVO;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName CreateTableUtil
 * @Description TODO
 * @Author WWW
 * @Date 2021/3/1 14:35
 * @Version 1.0
 */
public class CreateTableUtil {

    private static final Map<String, String> TYPE_MAP = new HashMap<>();

    static {
        TYPE_MAP.put("java.lang.Integer", "java.lang.Integer");
        TYPE_MAP.put("java.lang.Long", "java.lang.Long");
        TYPE_MAP.put("java.lang.Short", "java.lang.Short");
        TYPE_MAP.put("java.lang.Float", "java.lang.Float");
        TYPE_MAP.put("java.lang.Double", "java.lang.Double");
        TYPE_MAP.put("java.lang.BigDecimal", "java.lang.BigDecimal");
        TYPE_MAP.put("java.lang.String", "java.lang.String");
        TYPE_MAP.put("java.lang.Byte", "java.lang.Byte");
        TYPE_MAP.put("java.lang.Boolean", "java.lang.Boolean");
        TYPE_MAP.put("java.lang.Class", "java.lang.String");
        TYPE_MAP.put("java.util.Date", "java.util.Date");
        TYPE_MAP.put("java.util.Calendar", "java.util.Calendar");
        TYPE_MAP.put("java.util.Locale", "java.util.String");
        TYPE_MAP.put("java.util.TimeZone", "java.util.String");
        TYPE_MAP.put("java.util.Currency", "java.util.String");
        TYPE_MAP.put("java.sql.Date", "java.sql.Date");
        TYPE_MAP.put("java.sql.Time", "java.sql.Time");
        TYPE_MAP.put("java.sql.Timestamp", "java.sql.Timestamp");
        TYPE_MAP.put("java.sql.Clob", "java.sql.Clob");
        TYPE_MAP.put("java.sql.Blob", "java.sql.Blob");
        TYPE_MAP.put("java.lang.Object","java.lang.String");
        TYPE_MAP.put("java.util.Map","java.lang.String");

    }


    public static String createTable(TableVO tableVO) {
        //   1sql-type="text" string 转为text文本，2长度超过会自动转换
        List<ColumnVO> dataList = tableVO.getDataList();
        String xmlMapping = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + tableVO.getModelName() + "\" table=\"" + tableVO.getModelName() + "\">\n";

        xmlMapping += " <id name=\"id\" type=\"java.lang.Integer\" length=\"11\" unsaved-value=\"null\">\n" +
                "            <generator class=\"identity\" />\n" +
                "        </id>";
        for (ColumnVO columnVO : dataList) {

            xmlMapping +=
                    " <property type=\"" + columnVO.getFieldType() + "\" name=\"" + columnVO.getFieldName() + "\" length=\"" + columnVO.getFieldLength() +
                            "\" column=\"" + columnVO.getFieldName() + "\"/>\n";

        }
        xmlMapping += "   </class>\n" +
                "</hibernate-mapping>";
        return xmlMapping;
    }




    public static String getClassName(String aClass) {
        int i = aClass.lastIndexOf(".");
        String substring = aClass.substring(i + 1);
        return substring;
    }

    public static String getTypeName(String aClass) {
        String class_ = aClass.replace("class ", "");
        return TYPE_MAP.get(class_);
    }
}
