package com.tykj.workflowcore.model_layer.config;


import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


import java.util.Collections;


/**
 * @Author WWW
 * @Description
 * @Date 10:47 2021/3/26
 * @return
 **/
@Configuration
@EnableCaching
public class MyCacheConfig {

    @Bean
    public CacheManager cacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(Collections.singletonList(new ConcurrentMapCache("tableInfos")));
        return cacheManager;
    }
}
