package com.tykj.workflowcore;


import com.tykj.workflowcore.model_layer.controller.ModelController;
import com.tykj.workflowcore.model_layer.dao.TableInfoDao;
import com.tykj.workflowcore.model_layer.myEnum.ModelType;
import com.tykj.workflowcore.model_layer.service.ModelService;
import org.aspectj.lang.annotation.Before;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;


import java.util.List;
import java.util.Optional;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.*;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@AutoConfigureMockMvc
class WorkflowCoreApplicationTests {

    @Autowired
    ModelController modelController;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    TableInfoDao tableInfoDao;

    @Autowired
    MockMvc mockMvc;

    @Autowired
    ModelService modelService;

    @Before("")
    public void setUp() {
        mockMvc = MockMvcBuilders.standaloneSetup(modelController).build();
    }

    @Test
    void contextLoads() {
        System.out.println("11111111111111111111111");

    }
//#####################################模型层测试 start##############################################

    RequestBuilder request;

    /**
     * 测试表的条件查询
     * @throws Exception
     */
    @Test
    public void SearchTableVOTest() throws Exception {

        String SearchTableinfo_Json = "{\n" +
                "    \"modelName\":\"\",\n" +
                "    \"modelTitle\":\"\",\n" +
                "    \"modelType\":\"\"\n" +
                "}";
        request = post("/model/getAllEntity/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(SearchTableinfo_Json)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))  //条件
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果

    }

    /**
     * 测试列条件查询
     * @throws Exception
     */
    @Test
    public void testSearchColumnVO() throws Exception {

        String searchColumnV0_json = "{\n" +
                "\"dbId\":2\n" +
                "}";

        String searchColumnV0_json2 = "{\n" +
                "\"dbName\":\"sy_order\"\n" +
                "}";
        request = post("/model/getAllField/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(searchColumnV0_json2)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andExpect(content().string(not("[]")))
                .andDo(print());//打印输出结果
    }

    /**
     * 测试新增对象
     * @throws Exception
     */
    @Test
    public void addModelTest() throws Exception {

        String TableVo_json = "{\n" +
                "\"modelName\":\"people2\",\n" +
                "\"modelTitle\":\"人2\",\n" +
                "\"modelType\":1,\n" +
                "\"parentTable\":\"\",\n" +
                "\"description\":\"详细信息\",\n" +
                "\"dataList\":[\n" +
                "    {\"fieldName\": \"c1\", \"fieldTitle\": \"列1\", \"fieldType\": \"java.lang.String\", \"fieldLength\": \"255\"},\n" +
                "    {\"fieldName\": \"c2\", \"fieldTitle\": \"列2\", \"fieldType\": \"java.lang.String\", \"fieldLength\": \"255\"}\n" +
                "]\n" +
                "}";
        request = post("/model/addModel/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(TableVo_json)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andExpect(content().string(not("[]")))
                .andExpect(content().string(equalTo("{\"message\":\"新建成功\",\"data\":\"\"}")))
                .andDo(print());//打印输出结果
    }

    /**
     * 测试插入数据
     * @throws Exception
     */
    @Test
    public  void  insertValuesByTableName() throws Exception {
        String values_json="{\"techer\":{\"name\": \"zhangsan\",\"age\" :\"20\"}}";

        request = post("/model/insertValues/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(values_json)
                // 设置返回值类型为utf-8，否则默认为ISO-8859-1
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request).andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andExpect(content().string(not("[]")))
                .andExpect(content().string(equalTo("{\"message\":\"数据插入成功\",\"data\":\"\"}")))
                .andDo(print());//打印输出结果
    }

    /**
     * 测试查询全部
     * @throws Exception
     */
    @Test
    public void findAllByTableName() throws Exception {
        request=get("/model/getAll/")
                .param("tableName","techer")
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);

        mockMvc.perform(request)
                .andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andDo(print());

    }


    /**
     * 测试删除表
     */
    @Test
    public void testDelTable() throws Exception {
        String delete_JSON="{\n" +
                "\"dbName\":\"testentity\"\n" +
                "}";
        request=delete("/model/delete/")
                .contentType(MediaType.APPLICATION_JSON)
                .content(delete_JSON)
                .accept(MediaType.APPLICATION_JSON_UTF8_VALUE);
        mockMvc.perform(request)
                .andExpect(status().isOk())
                .andExpect(content().string(not("")))
                .andDo(print());
    }
}
